/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.storage.file.PackIndexV1;
import org.eclipse.jgit.storage.file.PackIndexV2;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackIndex
implements Iterable<MutableEntry> {
    protected byte[] packChecksum;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackIndex open(File idxFile) throws IOException {
        block14: {
            block13: {
                fd = new FileInputStream(idxFile);
                try {
                    try {
                        hdr = new byte[8];
                        IO.readFully(fd, hdr, 0, hdr.length);
                        if (PackIndex.isTOC(hdr)) {
                            v = NB.decodeInt32(hdr, 4);
                            switch (v) {
                                case 2: {
                                    var4_7 = new PackIndexV2(fd);
                                    var6_9 = null;
                                    break block13;
                                }
                                default: {
                                    throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, new Object[]{v}));
                                }
                            }
                        }
                        v = new PackIndexV1(fd, hdr);
                        break block14;
                    }
                    catch (IOException ioe) {
                        path = idxFile.getAbsolutePath();
                        err = new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, new Object[]{path}));
                        err.initCause(ioe);
                        throw err;
                    }
                }
                catch (Throwable var5_15) {
                    var6_11 = null;
                    try {
                        fd.close();
                        throw var5_15;
                    }
                    catch (IOException err2) {
                        throw var5_15;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 167->174)] { 
lbl35:
            // 1 sources

            fd.close();
            return var4_7;
lbl37:
            // 1 sources

            catch (IOException err2) {
                // empty catch block
            }
            return var4_7;
        }
        var6_10 = null;
        try {}
        catch (IOException err2) {
            // empty catch block
            return v;
        }
        fd.close();
        return v;
    }

    private static boolean isTOC(byte[] h) {
        byte[] toc = PackIndexWriter.TOC;
        for (int i = 0; i < toc.length; ++i) {
            if (h[i] == toc[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasObject(AnyObjectId id) {
        return this.findOffset(id) != -1L;
    }

    @Override
    public abstract Iterator<MutableEntry> iterator();

    abstract long getObjectCount();

    abstract long getOffset64Count();

    abstract ObjectId getObjectId(long var1);

    final ObjectId getObjectId(int nthPosition) {
        if (nthPosition >= 0) {
            return this.getObjectId((long)nthPosition);
        }
        int u31 = nthPosition >>> 1;
        int one = nthPosition & 1;
        return this.getObjectId((long)u31 << 1 | (long)one);
    }

    abstract long findOffset(AnyObjectId var1);

    abstract long findCRC32(AnyObjectId var1) throws MissingObjectException, UnsupportedOperationException;

    abstract boolean hasCRC32Support();

    abstract void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class EntriesIterator
    implements Iterator<MutableEntry> {
        protected final MutableEntry entry = this.initEntry();
        protected long returnedNumber = 0L;

        EntriesIterator() {
        }

        protected abstract MutableEntry initEntry();

        @Override
        public boolean hasNext() {
            return this.returnedNumber < PackIndex.this.getObjectCount();
        }

        @Override
        public abstract MutableEntry next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MutableEntry {
        final MutableObjectId idBuffer = new MutableObjectId();
        long offset;

        public long getOffset() {
            return this.offset;
        }

        public String name() {
            this.ensureId();
            return this.idBuffer.name();
        }

        public ObjectId toObjectId() {
            this.ensureId();
            return this.idBuffer.toObjectId();
        }

        public MutableEntry cloneEntry() {
            MutableEntry r = new MutableEntry();
            this.ensureId();
            r.idBuffer.fromObjectId(this.idBuffer);
            r.offset = this.offset;
            return r;
        }

        void ensureId() {
        }
    }
}

