/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.opensource;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;

public class MissingLicenseRule
extends AbstractRule {
    @Override
    public String getIdentifier() {
        return "OSSLicenseSectionRule";
    }

    @Override
    public String getDescription() {
        return "Each project should be licensed under a specific license so the terms of usage are clear.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        List licenses = mavenProject.getLicenses();
        if (licenses.isEmpty()) {
            InputLocation location = mavenProject.getOriginalModel().getLocation((Object)"licences");
            resultCollector.addViolation(mavenProject, this, "missing <licenses/> information", location == null ? this.getEmptyLocation(mavenProject) : location);
        } else {
            for (License license : licenses) {
                if (StringUtils.isEmpty((String)license.getName())) {
                    resultCollector.addViolation(mavenProject, this, "missing <name> in <license/> information", license.getLocation((Object)""));
                }
                if (!StringUtils.isEmpty((String)license.getUrl())) continue;
                resultCollector.addViolation(mavenProject, this, "missing <url> in <license/> information", license.getLocation((Object)""));
            }
        }
    }

    private InputLocation getEmptyLocation(MavenProject mavenProject) {
        InputSource source = new InputSource();
        source.setLocation(mavenProject.getOriginalModel().getPomFile() + "");
        return new InputLocation(0, 0, source);
    }
}

