/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.google.common.collect.Sets;
import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.util.ValueUtils;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class ProfileMustOnlyAddModulesRule
extends AbstractRule {
    private String patternString = "with-.*";
    private Pattern pattern = Pattern.compile(this.patternString);
    private final Set<String> allowableDescriptors = Sets.newHashSet((Object[])new String[]{"id", "activation", "modules", "source"});

    @Autowired
    public ProfileMustOnlyAddModulesRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    public void setPattern(String patternString) {
        this.patternString = patternString;
        this.pattern = Pattern.compile(patternString);
    }

    @Override
    public String getIdentifier() {
        return "ProfileOnlyAddModules";
    }

    @Override
    public String getDescription() {
        return "Profiles who's ids match the pattern " + this.patternString + " must only add modules to the reactor.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Model originalModel = mavenProject.getOriginalModel();
        Collection profiles = this.expressionEvaluator.getPath(originalModel, "/profiles");
        for (Profile profile : profiles) {
            if (profile.getId() == null || !this.pattern.matcher(profile.getId()).matches()) continue;
            JXPathBeanInfo profileBeanInfo = JXPathIntrospector.getBeanInfo(Profile.class);
            PropertyDescriptor[] propertyDescriptors = profileBeanInfo.getPropertyDescriptors();
            LinkedList<String> disallowedDescriptors = new LinkedList<String>();
            for (PropertyDescriptor descriptor : propertyDescriptors) {
                Object value;
                if (this.allowableDescriptors.contains(descriptor.getName()) || (value = ValueUtils.getValue((Object)profile, (PropertyDescriptor)descriptor)) == null) continue;
                if (value instanceof Collection) {
                    if (((Collection)value).isEmpty()) continue;
                    disallowedDescriptors.add(descriptor.getName());
                    continue;
                }
                if (value instanceof Map) {
                    if (((Map)value).isEmpty()) continue;
                    disallowedDescriptors.add(descriptor.getName());
                    continue;
                }
                disallowedDescriptors.add(descriptor.getName());
            }
            if (disallowedDescriptors.isEmpty()) continue;
            InputLocation location = this.modelUtil.getLocation(profile, "");
            resultCollector.addViolation(mavenProject, this, "Found '" + disallowedDescriptors + "' where only submodules are allowed", location);
        }
    }
}

