/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class GroupArtifactVersionMustBeInCorrectOrderRule
extends AbstractRule {
    private final Map<Class, List<String>> expectedOrderByClass = new HashMap<Class, List<String>>();

    @Autowired
    public GroupArtifactVersionMustBeInCorrectOrderRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    @Override
    public String getIdentifier() {
        return "GAVOrder";
    }

    @Override
    public String getDescription() {
        return "Maven convention is that the groupId, artifactId, and version elements be listed in that order.  Other elements with short, simple content, such as type, scope, classifier, etc, should be before elements with longer content, such as configuration, executions, and exclusions, otherwise they can be easily missed, leading to confusion.";
    }

    @Required
    public void setProjectElementOrder(List<String> expectedOrder) {
        this.expectedOrderByClass.put(Model.class, expectedOrder);
    }

    @Required
    public void setDependencyElementOrder(List<String> expectedOrder) {
        this.expectedOrderByClass.put(Dependency.class, expectedOrder);
    }

    @Required
    public void setPluginElementOrder(List<String> expectedOrder) {
        this.expectedOrderByClass.put(Plugin.class, expectedOrder);
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Collection<Object> objectsToCheck = this.modelUtil.findGAVObjects(mavenProject);
        block0: for (Object object : objectsToCheck) {
            List<String> sortOrder = this.findSortOrder(object.getClass());
            Map<Object, InputLocation> locations = this.modelUtil.getLocations(object);
            locations.remove("");
            TreeMap<InputLocation, Object> actualOrderedElements = new TreeMap<InputLocation, Object>(new InputLocationMapValueComparator());
            for (Map.Entry<Object, InputLocation> entry : locations.entrySet()) {
                actualOrderedElements.put(entry.getValue(), entry.getKey());
            }
            LinkedList<String> expectedOrderElements = new LinkedList<String>();
            for (String location : sortOrder) {
                if (!locations.containsKey(location)) continue;
                expectedOrderElements.add(location);
            }
            for (String location : actualOrderedElements.values()) {
                if (expectedOrderElements.contains(location)) continue;
                expectedOrderElements.add(location);
            }
            expectedOrderElements.retainAll(locations.keySet());
            Iterator expectedOrderElementIterator = expectedOrderElements.iterator();
            Iterator actualOrderedElementsIterator = actualOrderedElements.values().iterator();
            while (expectedOrderElementIterator.hasNext() && actualOrderedElementsIterator.hasNext()) {
                Object actualElement;
                Object expectedElement = expectedOrderElementIterator.next();
                if (expectedElement.equals(actualElement = actualOrderedElementsIterator.next())) continue;
                resultCollector.addViolation(mavenProject, this, "Found '" + actualElement + "' but was expecting '" + expectedElement + "'", locations.get(actualElement));
                continue block0;
            }
        }
    }

    private List<String> findSortOrder(Class<?> klass) {
        for (Class potentialClass : this.expectedOrderByClass.keySet()) {
            if (!potentialClass.isAssignableFrom(klass)) continue;
            return this.expectedOrderByClass.get(potentialClass);
        }
        throw new IllegalStateException("No expected sort order found for class " + klass);
    }

    private class InputLocationMapValueComparator
    implements Comparator<InputLocation> {
        private InputLocationMapValueComparator() {
        }

        @Override
        public int compare(InputLocation a, InputLocation b) {
            if (a.getLineNumber() == b.getLineNumber()) {
                return a.getColumnNumber() - b.getColumnNumber();
            }
            return a.getLineNumber() - b.getLineNumber();
        }
    }
}

