/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.model.Coordinates;
import com.lewisd.maven.lint.model.ObjectWithPath;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractReduntantVersionRule
extends AbstractRule {
    @Autowired
    private Log log;
    private final Set<Coordinates> excludedCoordinates = new HashSet<Coordinates>();
    private final PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator;

    public AbstractReduntantVersionRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil, PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator) {
        super(expressionEvaluator, modelUtil);
        this.pluginParameterExpressionEvaluator = pluginParameterExpressionEvaluator;
    }

    protected void checkForRedundantVersions(MavenProject mavenProject, ResultCollector resultCollector, ObjectWithPath<?> object, ObjectWithPath<?> inheritedObject, String dependencyDescription, String inheritedDescription) {
        Object modelObject = object.getObject();
        Object resolvedModelObject = this.tryResolveObject(object);
        if (this.isExcluded(resolvedModelObject)) {
            return;
        }
        String version = this.resolveVersion(modelObject, resolvedModelObject);
        String inheritedVersion = this.modelUtil.getVersion(this.tryResolveObject(inheritedObject));
        if (version != null && inheritedVersion != null && inheritedVersion.equals(version)) {
            InputLocation location = this.modelUtil.getLocation(modelObject, "version");
            String message = dependencyDescription + " '" + this.modelUtil.getKey(modelObject) + "' has same version (" + version + ") as " + inheritedDescription;
            resultCollector.addViolation(mavenProject, this, message, location);
        }
    }

    private String resolveVersion(Object modelObject, Object resolvedModelObject) {
        String version = this.modelUtil.getVersion(modelObject);
        if (version != null && version.contains("${")) {
            return this.modelUtil.getVersion(resolvedModelObject);
        }
        return version;
    }

    public void setExcludedCoordinates(Set<String> coordinates) {
        this.excludedCoordinates.clear();
        for (String coordinate : coordinates) {
            this.excludedCoordinates.add(Coordinates.parse(coordinate));
        }
    }

    private boolean isExcluded(Object modelObject) {
        Coordinates coords = this.modelUtil.getCoordinates(modelObject);
        for (Coordinates excludedCoordinate : this.excludedCoordinates) {
            if (!excludedCoordinate.matches(coords)) continue;
            return true;
        }
        return false;
    }

    private Object tryResolveObject(ObjectWithPath<?> objectWithPath) {
        try {
            return this.resolveObject(objectWithPath);
        }
        catch (IllegalStateException e) {
            this.log.warn((Throwable)e);
            return objectWithPath.getObject();
        }
    }

    private Object resolveObject(ObjectWithPath<?> objectWithPath) {
        Model model;
        Collection objects;
        Object object = objectWithPath.getObject();
        StringBuilder path = new StringBuilder();
        path.append(objectWithPath.getPath());
        path.append("[");
        path.append("groupId='").append(this.modelUtil.getGroupId(object)).append("'");
        path.append(" and artifactId='").append(this.modelUtil.getArtifactId(object)).append("'");
        String type = this.modelUtil.tryGetType(object);
        if (type != null) {
            path.append(" and type='").append(type).append("'");
        } else {
            path.append(" and not(type)");
        }
        String classifier = this.modelUtil.tryGetClassifier(object);
        if (classifier != null) {
            path.append(" and classifier='").append(classifier).append("'");
        } else {
            path.append(" and not(classifier)");
        }
        path.append("]");
        if (path.toString().contains("${")) {
            try {
                Object evaluate = this.pluginParameterExpressionEvaluator.evaluate(path.toString());
                path = new StringBuilder(evaluate.toString());
            }
            catch (ExpressionEvaluationException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((objects = this.expressionEvaluator.getPath(model = objectWithPath.getProject().getModel(), path.toString())).isEmpty()) {
            throw new IllegalStateException("Could not resolve " + object + " using path " + path);
        }
        if (objects.size() > 1) {
            throw new IllegalStateException("Found " + objects.size() + " objects using path " + path);
        }
        return objects.iterator().next();
    }

    protected Log getLog() {
        return this.log;
    }

    private void setLog(Log log) {
        this.log = log;
    }
}

