/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.report.summary;

import com.lewisd.maven.lint.Violation;
import com.lewisd.maven.lint.report.AbstractReportWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class SummaryReportWriter
extends AbstractReportWriter {
    private final Log log;

    @Autowired
    public SummaryReportWriter(Log log) {
        this.log = log;
    }

    @Override
    public void writeResults(MavenProject mavenProject, List<Violation> violations, File outputFile) throws IOException {
        Outputter out = SummaryReportWriter.isConsole(outputFile) ? new MavenLogOutputter() : new FileOutputter(outputFile);
        if (violations.isEmpty()) {
            out.write("[LINT] Completed with no violations");
        } else {
            out.write("[LINT] Completed with " + violations.size() + " violations");
            for (Violation violation : violations) {
                out.write("[LINT] " + violation);
            }
        }
        out.close();
    }

    public static boolean isConsole(File outputFile) {
        return "-".equals(outputFile.getName());
    }

    private class FileOutputter
    implements Outputter {
        private PrintWriter writer;

        public FileOutputter(File outputFile) throws IOException {
            this.writer = new PrintWriter(new FileWriter(outputFile));
        }

        @Override
        public void write(String message) {
            this.writer.println(message);
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }

    private class MavenLogOutputter
    implements Outputter {
        private MavenLogOutputter() {
        }

        @Override
        public void write(String message) {
            SummaryReportWriter.this.log.info((CharSequence)message);
        }

        @Override
        public void close() {
        }
    }

    private static interface Outputter {
        public void write(String var1);

        public void close();
    }
}

