/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.lewisd.maven.lint.ModelFactory;
import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.RuleInvoker;
import com.lewisd.maven.lint.plugin.AbstractContextMojo;
import com.lewisd.maven.lint.plugin.RulesSelector;
import com.lewisd.maven.lint.report.ReportWriter;
import com.lewisd.maven.lint.report.summary.SummaryReportWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.PatternSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, requiresProject=true)
public class CheckMojo
extends AbstractContextMojo {
    @Parameter(defaultValue="true", property="maven-lint.failOnViolation")
    private boolean failOnViolation;
    @Parameter(defaultValue="-", property="maven-lint.output.file.summary", readonly=true)
    private File summaryOutputFile;
    @Parameter(property="maven-lint.output.file.xml", defaultValue="${project.build.directory}/maven-lint-result.xml")
    private File xmlOutputFile;
    @Parameter(property="maven-lint.output.file.html", defaultValue="${project.build.directory}/maven-lint-result.html")
    private File htmlOutputFile;
    @Parameter(property="maven-lint.output.reports", defaultValue="summary,xml")
    private String outputReports;
    @Parameter
    private PatternSet rules;
    @Parameter
    private String[] onlyRunRules;
    @Parameter(property="maven-lint.rules")
    private String[] onlyRunRulesSwitch;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        ResultCollector resultCollector = (ResultCollector)this.getContext().getBean(ResultCollector.class);
        this.executeRules(resultCollector);
        List<String> outputReports = this.fillOutputReports(resultCollector);
        if (this.failOnViolation && resultCollector.hasViolations()) {
            String message = this.generateErrorMessage(outputReports);
            throw new MojoFailureException(message);
        }
    }

    private List<String> fillOutputReports(ResultCollector resultCollector) throws MojoExecutionException {
        LinkedList<String> outputReportList = new LinkedList<String>();
        if (!this.outputReports.trim().isEmpty()) {
            for (String report : this.outputReports.trim().split(",")) {
                outputReportList.add(report);
                this.getLog().info((CharSequence)("Writing " + report + " report"));
                ReportWriter reportWriter = (ReportWriter)this.getContext().getBean(report + "ResultWriter", ReportWriter.class);
                File outputFile = this.getOutputFileForReport(report);
                this.getLog().debug((CharSequence)("Writing to " + outputFile.getPath()));
                try {
                    reportWriter.writeResults(this.getProject(), resultCollector.getViolations(), outputFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while writing " + report + " report", (Exception)e);
                }
            }
        }
        return outputReportList;
    }

    private void executeRules(ResultCollector resultCollector) throws MojoExecutionException {
        ModelFactory modelFactory = (ModelFactory)this.getContext().getBean(ModelFactory.class);
        RuleInvoker ruleInvoker = new RuleInvoker(this.getProject(), modelFactory);
        String[] runRules = this.onlyRunRulesSwitch.length == 0 ? (this.onlyRunRules == null ? new String[]{} : this.onlyRunRules) : this.onlyRunRulesSwitch;
        Set<Rule> rulesToRun = new RulesSelector(this.getRules()).selectRules(this.rules, runRules);
        for (Rule rule : rulesToRun) {
            this.executeRule(resultCollector, ruleInvoker, rule);
        }
    }

    private void executeRule(ResultCollector resultCollector, RuleInvoker ruleInvoker, Rule rule) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Running rule " + rule.getIdentifier()));
        try {
            ruleInvoker.invokeRule(rule, resultCollector);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while performing check", e);
        }
    }

    @VisibleForTesting
    String generateErrorMessage(List<String> outputReportList) throws MojoExecutionException {
        StringBuffer message = new StringBuffer("[LINT] Violations found. ");
        if (outputReportList.isEmpty()) {
            message.append("No output reports have been configured.  Please see documentation regarding the outputReports configuration parameter.");
        } else {
            boolean wroteSummaryToConsole;
            ArrayList<String> remainingReports = new ArrayList<String>(outputReportList);
            if (outputReportList.contains("summary") && SummaryReportWriter.isConsole(this.summaryOutputFile)) {
                wroteSummaryToConsole = true;
                message.append("For more details, see error messages above");
                remainingReports.remove("summary");
            } else {
                wroteSummaryToConsole = false;
                message.append("For more details");
            }
            if (remainingReports.isEmpty()) {
                message.append(".");
            } else {
                if (wroteSummaryToConsole) {
                    message.append(", or ");
                } else {
                    message.append(" see ");
                }
                message.append("results in ");
                if (remainingReports.size() == 1) {
                    File outputFile = this.getOutputFileForReport(remainingReports.get(0));
                    message.append(outputFile.getAbsolutePath());
                } else {
                    message.append("one of the following files: ");
                    boolean first = true;
                    for (String report : remainingReports) {
                        if (!first) {
                            message.append(", ");
                        }
                        File outputFile = this.getOutputFileForReport(report);
                        message.append(outputFile.getAbsolutePath());
                        first = false;
                    }
                }
            }
        }
        return message.toString();
    }

    private File getOutputFileForReport(String report) throws MojoExecutionException {
        if ("summary".equals(report)) {
            return this.summaryOutputFile;
        }
        if ("xml".equals(report)) {
            return this.xmlOutputFile;
        }
        if ("html".equals(report)) {
            return this.htmlOutputFile;
        }
        throw new MojoExecutionException("Unsupported report: '" + report + "'");
    }

    private Set<Rule> getRules() {
        Collection ruleCollection = this.getContext().getBeansOfType(Rule.class).values();
        return Sets.newHashSet(ruleCollection);
    }
}

