/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.ModelBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class ProjectModels {
    private final Map<String, Object> models = new HashMap<String, Object>();
    private final Map<String, ModelBuilder> modelBuilders;

    public ProjectModels(MavenProject mavenProject, Map<String, ModelBuilder> modelBuilders) {
        this.models.put("mavenProject", mavenProject);
        this.modelBuilders = modelBuilders;
    }

    public Map<String, Object> getModels(Set<String> requiredModels) {
        HashMap<String, Object> ruleModels = new HashMap<String, Object>();
        for (String modelId : requiredModels) {
            Object model = this.models.get(modelId);
            if (model == null) {
                ModelBuilder modelBuilder = this.modelBuilders.get(modelId);
                if (modelBuilder == null) {
                    throw new IllegalArgumentException("No modelBuilder known for modelId '" + modelId + "'");
                }
                Map<String, Object> dependentModels = this.getModels(modelBuilder.getRequiredModels());
                model = modelBuilder.buildModel(dependentModels);
                this.models.put(modelId, model);
            }
            ruleModels.put(modelId, model);
        }
        return ruleModels;
    }
}

