/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.ModelBuilder;
import com.lewisd.maven.lint.ModelFactory;
import com.lewisd.maven.lint.ProjectModels;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class CachingModelFactory
implements ModelFactory {
    private final Map<String, ProjectModels> projectModelsByProjectId = new HashMap<String, ProjectModels>();
    private final Map<String, ModelBuilder> modelBuilders = new HashMap<String, ModelBuilder>();

    @Override
    public Map<String, Object> getModels(MavenProject mavenProject, Set<String> requiredModels) {
        ProjectModels projectModels = this.getProjectModels(mavenProject);
        return projectModels.getModels(requiredModels);
    }

    private ProjectModels getProjectModels(MavenProject mavenProject) {
        String id = mavenProject.getId();
        ProjectModels projectModels = this.projectModelsByProjectId.get(id);
        if (projectModels == null) {
            projectModels = new ProjectModels(mavenProject, Collections.unmodifiableMap(this.modelBuilders));
            this.projectModelsByProjectId.put(id, projectModels);
        }
        return projectModels;
    }

    @Override
    public void addModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilders.put(modelBuilder.getModelId(), modelBuilder);
    }
}

