/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;
import com.jpattern.orm.transaction.TransactionIsolation;
import com.jpattern.orm.transaction.TransactionPropagation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JdbcTemplateTransaction
implements Transaction {
    private final TransactionStatus transactionStatus;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateTransaction(PlatformTransactionManager platformTransactionManager, TransactionDefinition transactionDefinition) {
        this.platformTransactionManager = platformTransactionManager;
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        this.setIsolationLevel(definition, transactionDefinition.getIsolationLevel());
        this.setPropagation(definition, transactionDefinition.getPropagation());
        this.setTimeout(definition, transactionDefinition.getTimeout());
        definition.setReadOnly(transactionDefinition.isReadOnly());
        this.transactionStatus = platformTransactionManager.getTransaction((org.springframework.transaction.TransactionDefinition)definition);
    }

    private void setTimeout(DefaultTransactionDefinition definition, int timeout) {
        if (timeout >= 0) {
            definition.setTimeout(timeout);
        }
    }

    private void setPropagation(DefaultTransactionDefinition definition, TransactionPropagation propagation) {
        switch (propagation) {
            case MANDATORY: {
                definition.setPropagationBehavior(2);
                break;
            }
            case NESTED: {
                definition.setPropagationBehavior(6);
                break;
            }
            case NEVER: {
                definition.setPropagationBehavior(5);
                break;
            }
            case NOT_SUPPORTED: {
                definition.setPropagationBehavior(4);
                break;
            }
            case REQUIRED: {
                definition.setPropagationBehavior(0);
                break;
            }
            case REQUIRES_NEW: {
                definition.setPropagationBehavior(3);
                break;
            }
            case SUPPORTS: {
                definition.setPropagationBehavior(1);
                break;
            }
            default: {
                throw new OrmException("Unknown Transaction Propagation: " + propagation);
            }
        }
    }

    private void setIsolationLevel(DefaultTransactionDefinition definition, TransactionIsolation isolationLevel) {
        if (isolationLevel != TransactionIsolation.DEFAULT) {
            definition.setIsolationLevel(isolationLevel.getTransactionIsolation());
        }
    }

    public void setRollbackOnly() throws OrmException {
        try {
            this.transactionStatus.setRollbackOnly();
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    public void commit() throws OrmException {
        try {
            if (!this.transactionStatus.isCompleted()) {
                this.platformTransactionManager.commit(this.transactionStatus);
            }
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    public void rollback() throws OrmException {
        try {
            if (!this.transactionStatus.isCompleted()) {
                this.platformTransactionManager.rollback(this.transactionStatus);
            }
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    public boolean isClosed() {
        return this.transactionStatus.isCompleted();
    }
}

