/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.jdbctemplate.GeneratorKeyResultSet;
import com.jpattern.orm.jdbctemplate.JdbcTemplateExceptionTranslator;
import com.jpattern.orm.jdbctemplate.ResultSetReaderWrapper;
import com.jpattern.orm.session.BatchPreparedStatementSetter;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.SqlPerformerStrategy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcTemplateSqlPerformerStrategy
implements SqlPerformerStrategy {
    private final JdbcTemplate jdbcTemplate;

    public JdbcTemplateSqlPerformerStrategy(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void execute(String sql, int timeout) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setQueryTimeout(timeout);
            this.jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public <T> T query(String sql, int timeout, int maxRows, final com.jpattern.orm.session.PreparedStatementSetter pss, ResultSetReader<T> rse) throws OrmException {
        int oldMaxRows = this.jdbcTemplate.getMaxRows();
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setMaxRows(maxRows);
            this.jdbcTemplate.setQueryTimeout(timeout);
            Object object = this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    pss.set(ps);
                }
            }, new ResultSetReaderWrapper<T>(rse));
            return (T)object;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setMaxRows(oldMaxRows);
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public int update(String sql, int timeout, final com.jpattern.orm.session.PreparedStatementSetter pss) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setQueryTimeout(timeout);
            int n = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    pss.set(ps);
                }
            });
            return n;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public int update(final String sql, int timeout, final GeneratedKeyReader generatedKeyReader, final com.jpattern.orm.session.PreparedStatementSetter pss) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            PreparedStatementCreator psc = new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql, generatedKeyReader.generatedColumnNames());
                    pss.set(ps);
                    return ps;
                }
            };
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcTemplate.setQueryTimeout(timeout);
            int result = this.jdbcTemplate.update(psc, (KeyHolder)keyHolder);
            generatedKeyReader.read((ResultSet)new GeneratorKeyResultSet((KeyHolder)keyHolder));
            int n = result;
            return n;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public int[] batchUpdate(List<String> sqls, int timeout) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            this.jdbcTemplate.setQueryTimeout(timeout);
            int[] nArray = this.jdbcTemplate.batchUpdate(sqls.toArray(new String[0]));
            return nArray;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public int[] batchUpdate(String sql, final List<Object[]> args, int timeout) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            org.springframework.jdbc.core.BatchPreparedStatementSetter bpss = new org.springframework.jdbc.core.BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    int count = 0;
                    for (Object object : (Object[])args.get(i)) {
                        ps.setObject(++count, object);
                    }
                }

                public int getBatchSize() {
                    return args.size();
                }
            };
            this.jdbcTemplate.setQueryTimeout(timeout);
            int[] nArray = this.jdbcTemplate.batchUpdate(sql, bpss);
            return nArray;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }

    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter psc, int timeout) throws OrmException {
        int oldTimeout = this.jdbcTemplate.getQueryTimeout();
        try {
            org.springframework.jdbc.core.BatchPreparedStatementSetter bpss = new org.springframework.jdbc.core.BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    psc.set(ps, i);
                }

                public int getBatchSize() {
                    return psc.getBatchSize();
                }
            };
            this.jdbcTemplate.setQueryTimeout(timeout);
            int[] nArray = this.jdbcTemplate.batchUpdate(sql, bpss);
            return nArray;
        }
        catch (Exception e) {
            throw JdbcTemplateExceptionTranslator.doTranslate(e);
        }
        finally {
            this.jdbcTemplate.setQueryTimeout(oldTimeout);
        }
    }
}

