/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.jdbctemplate.JdbcTemplateSqlPerformerStrategy;
import com.jpattern.orm.jdbctemplate.JdbcTemplateTransaction;
import com.jpattern.orm.session.SessionStrategy;
import com.jpattern.orm.session.SqlPerformerStrategy;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateSessionStrategy
implements SessionStrategy {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateSessionStrategy(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    public Transaction getTransaction(TransactionDefinition transactionDefinition) throws OrmException {
        try {
            return new JdbcTemplateTransaction(this.platformTransactionManager, transactionDefinition);
        }
        catch (Exception e) {
            throw new OrmException(e);
        }
    }

    public SqlPerformerStrategy sqlPerformerStrategy() throws OrmException {
        return new JdbcTemplateSqlPerformerStrategy(this.jdbcTemplate);
    }
}

