/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.jdbctemplate;

import com.jpattern.orm.jdbctemplate.JdbcTemplateSessionStrategy;
import com.jpattern.orm.jdbctemplate.NullPlatformTransactionManager;
import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.session.SessionStrategy;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateSessionProvider
extends SessionProvider {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateSessionProvider(DataSource dataSource) {
        this(new JdbcTemplate(dataSource), (PlatformTransactionManager)new NullPlatformTransactionManager());
    }

    public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, (PlatformTransactionManager)new NullPlatformTransactionManager());
    }

    public JdbcTemplateSessionProvider(DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        this(new JdbcTemplate(dataSource), platformTransactionManager);
    }

    public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    public SessionStrategy getSessionStrategy() {
        return new JdbcTemplateSessionStrategy(this.jdbcTemplate, this.platformTransactionManager);
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }
}

