/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.jdbctemplate;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.sql.OrmSqlBadGrammarException;
import com.jpattern.orm.exception.sql.OrmSqlConcurrencyFailureException;
import com.jpattern.orm.exception.sql.OrmSqlDataAccessResourceFailureException;
import com.jpattern.orm.exception.sql.OrmSqlDataIntegrityViolationException;
import com.jpattern.orm.exception.sql.OrmSqlException;
import com.jpattern.orm.exception.sql.OrmSqlTransientDataAccessResourceException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.BadSqlGrammarException;

public class JdbcTemplateExceptionTranslator {
    private JdbcTemplateExceptionTranslator() {
    }

    public static OrmSqlException doTranslate(Exception ex) {
        if (ex instanceof OrmException) {
            throw (OrmException)ex;
        }
        if (ex instanceof BadSqlGrammarException) {
            return new OrmSqlBadGrammarException(ex);
        }
        if (ex instanceof DataIntegrityViolationException) {
            return new OrmSqlDataIntegrityViolationException(ex);
        }
        if (ex instanceof DataAccessResourceFailureException) {
            return new OrmSqlDataAccessResourceFailureException(ex);
        }
        if (ex instanceof TransientDataAccessResourceException) {
            return new OrmSqlTransientDataAccessResourceException(ex);
        }
        if (ex instanceof ConcurrencyFailureException) {
            return new OrmSqlConcurrencyFailureException(ex);
        }
        return new OrmSqlException(ex);
    }
}

