/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.template.Env;
import com.jfinal.template.io.ByteWriter;
import com.jfinal.template.io.CharWriter;
import com.jfinal.template.io.FastStringWriter;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class Template {
    private Env env;
    private Stat ast;

    public Template(Env env, Stat ast) {
        if (env == null || ast == null) {
            throw new IllegalArgumentException("env and ast can not be null");
        }
        this.env = env;
        this.ast = ast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, OutputStream outputStream) {
        ByteWriter byteWriter = this.env.engineConfig.writerBuffer.getByteWriter(outputStream);
        try {
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), byteWriter);
        }
        finally {
            byteWriter.close();
        }
    }

    public void render(OutputStream outputStream) {
        this.render(null, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<?, ?> data, Writer writer) {
        CharWriter charWriter = this.env.engineConfig.writerBuffer.getCharWriter(writer);
        try {
            this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), charWriter);
        }
        finally {
            charWriter.close();
        }
    }

    public void render(Writer writer) {
        this.render(null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderToString(Map<?, ?> data) {
        FastStringWriter fsw = this.env.engineConfig.writerBuffer.getFastStringWriter();
        try {
            this.render(data, fsw);
            String string = fsw.toString();
            return string;
        }
        finally {
            fsw.close();
        }
    }

    public StringBuilder renderToStringBuilder(Map<?, ?> data) {
        FastStringWriter fsw = new FastStringWriter();
        this.render(data, fsw);
        return fsw.getBuffer();
    }

    public void render(Map<?, ?> data, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.render(data, fos);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void render(Map<?, ?> data, String fileName) {
        this.render(data, new File(fileName));
    }

    public boolean isModified() {
        return this.env.isSourceListModified();
    }
}

