/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat.ast;

import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.stat.Ctrl;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.Writer;
import java.util.List;

public class StatList
extends Stat {
    public static final Stat[] NULL_STATS = new Stat[0];
    private Stat[] statArray;

    public StatList(List<Stat> statList) {
        this.statArray = statList.size() > 0 ? statList.toArray(new Stat[statList.size()]) : NULL_STATS;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        for (Stat stat : this.statArray) {
            if (ctrl.isJump()) break;
            stat.exec(env, scope, writer);
        }
    }

    public int length() {
        return this.statArray.length;
    }

    public Stat getStat(int index) {
        if (index < 0 || index >= this.statArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + this.statArray.length, this.location);
        }
        return this.statArray[index];
    }
}

