/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat.ast;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.Logic;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.Writer;

public class ElseIf
extends Stat {
    private ExprList cond;
    private Stat stat;
    private Stat elseIfOrElse;

    public ElseIf(ExprList cond, Stat stat, Location location) {
        if (cond.length() == 0) {
            throw new ParseException("The condition expression of #elseif statement can not be blank", location);
        }
        this.cond = cond;
        this.stat = stat;
    }

    @Override
    public void setStat(Stat elseIfOrElse) {
        this.elseIfOrElse = elseIfOrElse;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (Logic.isTrue(this.cond.eval(scope))) {
            this.stat.exec(env, scope, writer);
        } else if (this.elseIfOrElse != null) {
            this.elseIfOrElse.exec(env, scope, writer);
        }
    }
}

