/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ExprParser;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.ForCtrl;
import com.jfinal.template.stat.Lexer;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParaToken;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Symbol;
import com.jfinal.template.stat.TextToken;
import com.jfinal.template.stat.Token;
import com.jfinal.template.stat.ast.Break;
import com.jfinal.template.stat.ast.Call;
import com.jfinal.template.stat.ast.Continue;
import com.jfinal.template.stat.ast.Define;
import com.jfinal.template.stat.ast.Else;
import com.jfinal.template.stat.ast.ElseIf;
import com.jfinal.template.stat.ast.For;
import com.jfinal.template.stat.ast.If;
import com.jfinal.template.stat.ast.Include;
import com.jfinal.template.stat.ast.Return;
import com.jfinal.template.stat.ast.Set;
import com.jfinal.template.stat.ast.SetGlobal;
import com.jfinal.template.stat.ast.SetLocal;
import com.jfinal.template.stat.ast.Stat;
import com.jfinal.template.stat.ast.StatList;
import com.jfinal.template.stat.ast.Text;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private static final Token EOF = new Token(Symbol.EOF, -1);
    private int forward = 0;
    private List<Token> tokenList;
    private StringBuilder content;
    private String fileName;
    private Env env;

    public Parser(Env env, StringBuilder content, String fileName) {
        this.env = env;
        this.content = content;
        this.fileName = fileName;
    }

    private Token peek() {
        return this.tokenList.get(this.forward);
    }

    private Token move() {
        return this.tokenList.get(++this.forward);
    }

    private Token matchPara(Token name) {
        Token current = this.peek();
        if (current.symbol == Symbol.PARA) {
            this.move();
            return current;
        }
        throw new ParseException("Can not match the parameter of directive #" + name.value(), this.getLocation(name.row));
    }

    private void matchEnd(Token name) {
        if (this.peek().symbol == Symbol.END) {
            this.move();
            return;
        }
        throw new ParseException("Can not match the #end of directive #" + name.value(), this.getLocation(name.row));
    }

    public Stat parse() {
        this.tokenList = new Lexer(this.content, this.fileName).scan();
        this.tokenList.add(EOF);
        StatList statList = this.statList();
        if (this.peek() != EOF) {
            throw new ParseException("Syntax error: can not match " + this.peek().value(), this.getLocation(this.peek().row));
        }
        return statList;
    }

    private StatList statList() {
        Stat stat;
        ArrayList<Stat> statList = new ArrayList<Stat>();
        while ((stat = this.stat()) != null) {
            if (stat instanceof Define) {
                this.env.addFunction((Define)stat);
                continue;
            }
            if (stat instanceof Text && ((Text)stat).isEmpty()) continue;
            statList.add(stat);
        }
        return new StatList(statList);
    }

    private Stat stat() {
        Token name = this.peek();
        switch (name.symbol) {
            case TEXT: {
                this.move();
                return new Text(((TextToken)name).getContent()).setLocation(this.getLocation(name.row));
            }
            case OUTPUT: {
                this.move();
                Token para = this.matchPara(name);
                Location loc = this.getLocation(name.row);
                return this.env.getEngineConfig().getOutputDirective(this.parseExprList(para), loc).setLocation(loc);
            }
            case INCLUDE: {
                this.move();
                Token para = this.matchPara(name);
                return new Include(this.env, this.parseExprList(para), this.fileName, this.getLocation(name.row));
            }
            case FOR: {
                this.move();
                Token para = this.matchPara(name);
                StatList statList = this.statList();
                Else _else = null;
                if (this.peek().symbol == Symbol.ELSE) {
                    this.move();
                    StatList elseStats = this.statList();
                    _else = new Else(elseStats);
                }
                this.matchEnd(name);
                return new For(this.parseForCtrl(para), statList, _else).setLocation(this.getLocation(name.row));
            }
            case IF: {
                If ret;
                this.move();
                Token para = this.matchPara(name);
                StatList statList = this.statList();
                Stat current = ret = new If(this.parseExprList(para), statList, this.getLocation(name.row));
                Token elseIfToken = this.peek();
                while (elseIfToken.symbol == Symbol.ELSEIF) {
                    this.move();
                    para = this.matchPara(elseIfToken);
                    statList = this.statList();
                    ElseIf elseIf = new ElseIf(this.parseExprList(para), statList, this.getLocation(elseIfToken.row));
                    ((Stat)current).setStat(elseIf);
                    current = elseIf;
                    elseIfToken = this.peek();
                }
                if (this.peek().symbol == Symbol.ELSE) {
                    this.move();
                    statList = this.statList();
                    Else _else = new Else(statList);
                    ((Stat)current).setStat(_else);
                }
                this.matchEnd(name);
                return ret;
            }
            case DEFINE: {
                String functionName = name.value();
                this.move();
                Token para = this.matchPara(name);
                StatList stat = this.statList();
                this.matchEnd(name);
                return new Define(functionName, this.parseExprList(para), stat, this.getLocation(name.row));
            }
            case CALL: {
                String functionName = name.value();
                this.move();
                Token para = this.matchPara(name);
                return new Call(functionName, this.parseExprList(para), false).setLocation(this.getLocation(name.row));
            }
            case CALL_IF_DEFINED: {
                String functionName = name.value();
                this.move();
                Token para = this.matchPara(name);
                return new Call(functionName, this.parseExprList(para), true).setLocation(this.getLocation(name.row));
            }
            case SET: {
                this.move();
                Token para = this.matchPara(name);
                return new Set(this.parseExprList(para), this.getLocation(name.row));
            }
            case SET_LOCAL: {
                this.move();
                Token para = this.matchPara(name);
                return new SetLocal(this.parseExprList(para), this.getLocation(name.row));
            }
            case SET_GLOBAL: {
                this.move();
                Token para = this.matchPara(name);
                return new SetGlobal(this.parseExprList(para), this.getLocation(name.row));
            }
            case CONTINUE: {
                this.move();
                return Continue.me;
            }
            case BREAK: {
                this.move();
                return Break.me;
            }
            case RETURN: {
                this.move();
                return Return.me;
            }
            case ID: {
                Stat dire = this.env.getEngineConfig().getDirective(name.value());
                if (dire == null) {
                    throw new ParseException("Directive not found: #" + name.value(), this.getLocation(name.row));
                }
                Stat ret = this.createDirective(dire, name).setLocation(this.getLocation(name.row));
                this.move();
                Token para = this.matchPara(name);
                ret.setExprList(this.parseExprList(para));
                if (dire.hasEnd()) {
                    StatList statList = this.statList();
                    ret.setStat(statList);
                    this.matchEnd(name);
                }
                return ret;
            }
            case PARA: 
            case ELSEIF: 
            case ELSE: 
            case END: 
            case EOF: {
                return null;
            }
        }
        throw new ParseException("Syntax error: can not match the token: " + name.value(), this.getLocation(name.row));
    }

    private Location getLocation(int row) {
        return new Location(this.fileName, row);
    }

    private Stat createDirective(Stat dire, Token name) {
        try {
            return (Stat)dire.getClass().newInstance();
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), this.getLocation(name.row), e);
        }
    }

    private ExprList parseExprList(Token paraToken) {
        return new ExprParser((ParaToken)paraToken, this.env.getEngineConfig(), this.fileName).parseExprList();
    }

    private ForCtrl parseForCtrl(Token paraToken) {
        return new ExprParser((ParaToken)paraToken, this.env.getEngineConfig(), this.fileName).parseForCtrl();
    }
}

