/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.EngineConfig;
import com.jfinal.template.Env;
import com.jfinal.template.FileStringSource;
import com.jfinal.template.IStringSource;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Assign;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.stat.Ctrl;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Parser;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Define;
import com.jfinal.template.stat.ast.Include;
import com.jfinal.template.stat.ast.Stat;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class RenderDirective
extends Directive {
    private String parentFileName;
    private Map<String, StatInfo> statInfoCache = new HashMap<String, StatInfo>();

    @Override
    public void setExprList(ExprList exprList) {
        int len = exprList.length();
        if (len == 0) {
            throw new ParseException("The parameter of #render directive can not be blank", this.location);
        }
        if (len > 1) {
            for (int i = 1; i < len; ++i) {
                if (exprList.getExpr(i) instanceof Assign) continue;
                throw new ParseException("The " + i + "th parameter of #render directive must be an assignment expression", this.location);
            }
        }
        this.parentFileName = this.location.getTemplateFile();
        this.exprList = exprList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalAssignExpressionAndGetFileName(Scope scope) {
        Ctrl ctrl = scope.getCtrl();
        try {
            ctrl.setLocalAssignment();
            Object object = this.exprList.evalExprList(scope)[0];
            return object;
        }
        finally {
            ctrl.setWisdomAssignment();
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object value = this.evalAssignExpressionAndGetFileName(scope = new Scope(scope));
        if (!(value instanceof String)) {
            throw new TemplateException("The parameter value of #render directive must be String", this.location);
        }
        String subFileName = Include.getSubFileName((String)value, this.parentFileName);
        StatInfo statInfo = this.statInfoCache.get(subFileName);
        if (statInfo == null) {
            statInfo = this.parseStatInfo(env, subFileName);
            this.statInfoCache.put(subFileName, statInfo);
        } else if (env.getEngineConfig().isDevMode() && (statInfo.stringSource.isModified() || statInfo.env.isStringSourceListModified())) {
            statInfo = this.parseStatInfo(env, subFileName);
            this.statInfoCache.put(subFileName, statInfo);
        }
        statInfo.stat.exec(statInfo.env, scope, writer);
        scope.getCtrl().setJumpNone();
    }

    private StatInfo parseStatInfo(Env env, String subFileName) {
        EngineConfig config = env.getEngineConfig();
        FileStringSource fileStringSource = new FileStringSource(config.getBaseTemplatePath(), subFileName, config.getEncoding());
        try {
            EnvSub envSub = new EnvSub(env);
            Stat stat = new Parser(envSub, fileStringSource.getContent(), subFileName).parse();
            return new StatInfo(envSub, stat, fileStringSource);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), this.location, e);
        }
    }

    private static class EnvSub
    extends Env {
        Env parentEnv;

        public EnvSub(Env parentEnv) {
            super(parentEnv.getEngineConfig());
            this.parentEnv = parentEnv;
        }

        @Override
        public Define getFunction(String functionName) {
            Define func = (Define)this.functionMap.get(functionName);
            return func != null ? func : this.parentEnv.getFunction(functionName);
        }
    }

    private static class StatInfo {
        EnvSub env;
        Stat stat;
        IStringSource stringSource;

        StatInfo(EnvSub env, Stat stat, IStringSource stringSource) {
            this.env = env;
            this.stat = stat;
            this.stringSource = stringSource;
        }
    }
}

