/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NowDirective
extends Directive {
    public void setExrpList(ExprList exprList) {
        if (exprList.length() > 1) {
            throw new ParseException("#now directive support one parameter only", this.location);
        }
        super.setExprList(exprList);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String dataPattern;
        if (this.exprList.length() == 0) {
            dataPattern = env.getEngineConfig().getDatePattern();
        } else {
            Object dp = this.exprList.eval(scope);
            if (dp instanceof String) {
                dataPattern = (String)dp;
            } else {
                throw new TemplateException("The parameter of #new directive must be String", this.location);
            }
        }
        try {
            String value = new SimpleDateFormat(dataPattern).format(new Date());
            this.write(writer, value);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

