/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateDirective
extends Directive {
    private Expr valueExpr;
    private Expr datePatternExpr;
    private int paraNum;

    @Override
    public void setExprList(ExprList exprList) {
        this.paraNum = exprList.length();
        if (this.paraNum > 2) {
            throw new ParseException("Wrong number parameter of #date directive, two parameters allowed at most", this.location);
        }
        if (this.paraNum == 0) {
            this.valueExpr = null;
            this.datePatternExpr = null;
        } else if (this.paraNum == 1) {
            this.valueExpr = exprList.getExprArray()[0];
            this.datePatternExpr = null;
        } else if (this.paraNum == 2) {
            this.valueExpr = exprList.getExprArray()[0];
            this.datePatternExpr = exprList.getExprArray()[1];
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (this.paraNum == 0) {
            this.outputToday(env, writer);
        } else if (this.paraNum == 1) {
            this.outputWithoutDatePattern(env, scope, writer);
        } else if (this.paraNum == 2) {
            this.outputWithDatePattern(env, scope, writer);
        }
    }

    private void outputToday(Env env, Writer writer) {
        String value = this.format(new Date(), env.getEngineConfig().getDatePattern());
        this.write(writer, value.toString());
    }

    private void outputWithoutDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value != null) {
            value = this.format(value, env.getEngineConfig().getDatePattern());
            this.write(writer, value.toString());
        }
    }

    private void outputWithDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value == null) {
            return;
        }
        Object dp = this.datePatternExpr.eval(scope);
        if (!(dp instanceof String)) {
            throw new TemplateException("The sencond parameter dataPattern of #date directive must be String", this.location);
        }
        value = this.format(value, (String)dp);
        this.write(writer, value.toString());
    }

    private String format(Object value, String datePattern) {
        try {
            return new SimpleDateFormat(datePattern).format(value);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

