/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.math.BigDecimal;

public class Unary
extends Expr {
    private Sym op;
    private Expr expr;

    public Unary(Sym op, Expr expr, Location location) {
        if (expr == null) {
            throw new ParseException("The parameter of \"" + op.value() + "\" operator can not be blank", location);
        }
        this.op = op;
        this.expr = expr;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object value = this.expr.eval(scope);
        if (value == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The parameter of \"" + this.op.value() + "\" operator can not be blank", this.location);
        }
        if (!(value instanceof Number)) {
            throw new TemplateException(this.op.value() + " operator only support int long float double BigDecimal type", this.location);
        }
        switch (this.op) {
            case ADD: {
                return value;
            }
            case SUB: {
                Number n = (Number)value;
                if (n instanceof Integer) {
                    return -n.intValue();
                }
                if (n instanceof Long) {
                    return -n.longValue();
                }
                if (n instanceof Float) {
                    return Float.valueOf(-n.floatValue());
                }
                if (n instanceof Double) {
                    return -n.doubleValue();
                }
                if (n instanceof BigDecimal) {
                    return ((BigDecimal)n).negate();
                }
                throw new TemplateException("Unsupported data type: " + n.getClass().getName(), this.location);
            }
        }
        throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
    }
}

