/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.Method;
import com.jfinal.template.expr.ast.MethodKit;
import com.jfinal.template.expr.ast.SharedMethodKit;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;

public class SharedMethod
extends Expr {
    private SharedMethodKit sharedMethodKit;
    private String methodName;
    private ExprList exprList;

    public SharedMethod(SharedMethodKit sharedMethodKit, String methodName, ExprList exprList, Location location) {
        if (MethodKit.isForbiddenMethod(methodName)) {
            throw new ParseException("Forbidden method: " + methodName, location);
        }
        this.sharedMethodKit = sharedMethodKit;
        this.methodName = methodName;
        this.exprList = exprList;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object[] argValues = this.exprList.evalExprList(scope);
        SharedMethodKit.SharedMethodInfo sharedMethodInfo = this.sharedMethodKit.getSharedMethodInfo(this.methodName, argValues);
        if (sharedMethodInfo == null) {
            throw new TemplateException(Method.buildMethodNotFoundSignature("Shared method not found: ", this.methodName, argValues), this.location);
        }
        try {
            return sharedMethodInfo.invoke(argValues);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

