/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.kit.HashKit;
import com.jfinal.template.expr.ast.MethodInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MethodKit {
    private static final Class<?>[] NULL_ARG_TYPES;
    private static final Set<String> forbiddenMethods;
    private static final Set<Class<?>> forbiddenClasses;
    private static final Map<Class<?>, Class<?>> primitiveMap;
    private static final ConcurrentHashMap<String, Object> methodCache;

    public static boolean isForbiddenClass(Class<?> clazz) {
        return forbiddenClasses.contains(clazz);
    }

    public static boolean isForbiddenMethod(String methodName) {
        return forbiddenMethods.contains(methodName);
    }

    public static void addForbiddenMethod(String methodName) {
        forbiddenMethods.add(methodName);
    }

    public static MethodInfo getMethod(Class<?> targetClass, String methodName, Object[] argValues) {
        Class<?>[] argTypes = MethodKit.getArgTypes(argValues);
        String key = MethodKit.getMethodKey(targetClass, methodName, argTypes);
        Object method = methodCache.get(key);
        if (method == null) {
            method = MethodKit.doGetMethod(key, targetClass, methodName, argTypes);
            if (method != null) {
                methodCache.putIfAbsent(key, method);
            } else {
                methodCache.put(key, Boolean.FALSE);
            }
        }
        return method instanceof MethodInfo ? (MethodInfo)method : null;
    }

    public static MethodInfo getGetterMethod(String key, Class<?> targetClass, String methodName) {
        Object getterMethod = methodCache.get(key);
        if (getterMethod == null) {
            getterMethod = MethodKit.doGetMethod(key, targetClass, methodName, NULL_ARG_TYPES);
            if (getterMethod != null) {
                methodCache.putIfAbsent(key, getterMethod);
            } else {
                methodCache.put(key, Boolean.FALSE);
            }
        }
        return getterMethod instanceof MethodInfo ? (MethodInfo)getterMethod : null;
    }

    static Class<?>[] getArgTypes(Object[] argValues) {
        if (argValues == null || argValues.length == 0) {
            return NULL_ARG_TYPES;
        }
        Class[] argTypes = new Class[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            argTypes[i] = argValues[i] != null ? argValues[i].getClass() : null;
        }
        return argTypes;
    }

    private static MethodInfo doGetMethod(String key, Class<?> targetClass, String methodName, Class<?>[] argTypes) {
        Method[] methodArray;
        if (forbiddenClasses.contains(targetClass)) {
            throw new RuntimeException("Forbidden class: " + targetClass.getName());
        }
        if (forbiddenMethods.contains(methodName)) {
            throw new RuntimeException("Forbidden method: " + methodName);
        }
        for (Method method : methodArray = targetClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] paraTypes = method.getParameterTypes();
            if (MethodKit.matchFixedArgTypes(paraTypes, argTypes)) {
                return new MethodInfo(key, targetClass, method);
            }
            if (!method.isVarArgs() || !MethodKit.matchVarArgTypes(paraTypes, argTypes)) continue;
            return new MethodInfo(key, targetClass, method);
        }
        return null;
    }

    static boolean matchFixedArgTypes(Class<?>[] paraTypes, Class<?>[] argTypes) {
        if (paraTypes.length != argTypes.length) {
            return false;
        }
        return MethodKit.matchRangeTypes(paraTypes, argTypes, paraTypes.length);
    }

    private static boolean matchRangeTypes(Class<?>[] paraTypes, Class<?>[] argTypes, int matchLength) {
        for (int i = 0; i < matchLength; ++i) {
            if (argTypes[i] == null) {
                if (!paraTypes[i].isPrimitive()) continue;
                return false;
            }
            if (paraTypes[i].isAssignableFrom(argTypes[i]) || paraTypes[i] == argTypes[i] || primitiveMap.get(paraTypes[i]) == argTypes[i]) continue;
            return false;
        }
        return true;
    }

    static boolean matchVarArgTypes(Class<?>[] paraTypes, Class<?>[] argTypes) {
        int fixedParaLength = paraTypes.length - 1;
        if (argTypes.length < fixedParaLength) {
            return false;
        }
        if (!MethodKit.matchRangeTypes(paraTypes, argTypes, fixedParaLength)) {
            return false;
        }
        Class<?> varArgType = paraTypes[paraTypes.length - 1].getComponentType();
        for (int i = fixedParaLength; i < argTypes.length; ++i) {
            if (argTypes[i] == null) {
                if (!varArgType.isPrimitive()) continue;
                return false;
            }
            if (varArgType.isAssignableFrom(argTypes[i]) || varArgType == argTypes[i] || primitiveMap.get(varArgType) == argTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static String getMethodKey(Class<?> targetClass, String methodName, Class<?>[] argTypes) {
        StringBuilder key = new StringBuilder(96);
        key.append(targetClass.getName());
        key.append('.').append(methodName);
        if (argTypes != null && argTypes.length > 0) {
            MethodKit.createArgTypesDigest(argTypes, key);
        }
        return key.toString();
    }

    static void createArgTypesDigest(Class<?>[] argTypes, StringBuilder key) {
        StringBuilder argTypesDigest = new StringBuilder(64);
        for (int i = 0; i < argTypes.length; ++i) {
            Class<?> type = argTypes[i];
            argTypesDigest.append(type != null ? type.getName() : "null");
        }
        key.append(HashKit.md5(argTypesDigest.toString()));
    }

    static {
        String[] ms;
        Class[] cs;
        NULL_ARG_TYPES = new Class[0];
        forbiddenMethods = new HashSet<String>();
        forbiddenClasses = new HashSet();
        primitiveMap = new HashMap();
        methodCache = new ConcurrentHashMap();
        for (Class c : cs = new Class[]{System.class, Runtime.class, Thread.class, Class.class, ClassLoader.class, File.class}) {
            forbiddenClasses.add(c);
        }
        for (String m : ms = new String[]{"getClass", "getDeclaringClass", "forName", "newInstance", "getClassLoader", "getMethod", "getMethods", "getField", "getFields", "notify", "notifyAll", "wait", "load", "exit", "loadLibrary", "halt", "stop", "suspend", "resume", "setDaemon", "setPriority"}) {
            forbiddenMethods.add(m);
        }
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.class, Byte.TYPE);
        primitiveMap.put(Short.class, Short.TYPE);
        primitiveMap.put(Integer.class, Integer.TYPE);
        primitiveMap.put(Long.class, Long.TYPE);
        primitiveMap.put(Float.class, Float.TYPE);
        primitiveMap.put(Double.class, Double.TYPE);
        primitiveMap.put(Character.class, Character.TYPE);
        primitiveMap.put(Boolean.class, Boolean.TYPE);
    }
}

