/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;

public class FieldKit {
    private static final ConcurrentHashMap<String, Object> fieldCache = new ConcurrentHashMap();

    public static Field getField(String key, Class<?> targetClass, String fieldName) {
        Object field = fieldCache.get(key);
        if (field == null) {
            field = FieldKit.doGetField(targetClass, fieldName);
            if (field != null) {
                fieldCache.putIfAbsent(key, field);
            } else {
                fieldCache.put(key, Boolean.FALSE);
            }
        }
        return field instanceof Field ? (Field)field : null;
    }

    private static Field doGetField(Class<?> targetClass, String fieldName) {
        Field[] fs;
        for (Field f : fs = targetClass.getFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public static String getFieldKey(Class<?> targetClass, String getterName) {
        return new StringBuilder(64).append(targetClass.getName()).append('.').append(getterName).toString();
    }
}

