/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class Assign
extends Expr {
    private String id;
    private Expr index;
    private Expr right;

    public Assign(String id, Expr index, Expr right, Location location) {
        if (index == null) {
            throw new ParseException("The index expression of array assignment can not be null", location);
        }
        if (right == null) {
            throw new ParseException("The expression on the right side of an assignment expression can not be null", location);
        }
        this.id = id;
        this.index = index;
        this.right = right;
        this.location = location;
    }

    public Assign(String id, Expr right, Location location) {
        if (right == null) {
            throw new ParseException("The expression on the right side of an assignment expression can not be null", location);
        }
        this.id = id;
        this.index = null;
        this.right = right;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        if (this.index == null) {
            return this.assignVariable(scope);
        }
        return this.assignElement(scope);
    }

    Object assignVariable(Scope scope) {
        Object rightValue = this.right.eval(scope);
        if (scope.getCtrl().isWisdomAssignment()) {
            scope.set(this.id, rightValue);
        } else if (scope.getCtrl().isLocalAssignment()) {
            scope.setLocal(this.id, rightValue);
        } else {
            scope.setGlobal(this.id, rightValue);
        }
        return rightValue;
    }

    Object assignElement(Scope scope) {
        Object target = scope.get(this.id);
        if (target == null) {
            throw new TemplateException("The assigned targets \"" + this.id + "\" can not be null", this.location);
        }
        Object idx = this.index.eval(scope);
        if (idx == null) {
            throw new TemplateException("The index of list/array and the key of map can not be null", this.location);
        }
        if (target instanceof Map) {
            Object value = this.right.eval(scope);
            ((Map)target).put(idx, value);
            return value;
        }
        if (!(idx instanceof Integer)) {
            throw new TemplateException("The index of list/array can only be integer", this.location);
        }
        if (target instanceof List) {
            Object value = this.right.eval(scope);
            ((List)target).set((Integer)idx, value);
            return value;
        }
        if (target.getClass().isArray()) {
            Object value = this.right.eval(scope);
            Array.set(target, (Integer)idx, value);
            return value;
        }
        throw new TemplateException("Only the list array and map is supported by index assignment", this.location);
    }
}

