/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.template.IStringSource;

public class MemoryStringSource
implements IStringSource {
    private String key;
    private StringBuilder content;

    public MemoryStringSource(String content) {
        if (StrKit.isBlank(content)) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = new StringBuilder(content);
        this.key = HashKit.md5(content);
    }

    public MemoryStringSource(StringBuilder content) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = content;
        this.key = HashKit.md5(content.toString());
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StringBuilder getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Key : ").append(this.key).append("\n");
        sb.append("Content : ").append((CharSequence)this.content).append("\n");
        return sb.toString();
    }
}

