/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.kit.LogKit;
import com.jfinal.template.IStringSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileStringSource
implements IStringSource {
    private String finalFileName;
    private String fileName;
    private String encoding;
    private long lastModified;

    public FileStringSource(String baseTemplatePath, String fileName, String encoding) {
        this.finalFileName = this.buildFinalFileName(baseTemplatePath, fileName);
        this.fileName = fileName;
        this.encoding = encoding;
    }

    public FileStringSource(String baseTemplatePath, String fileName) {
        this(baseTemplatePath, fileName, "UTF-8");
    }

    @Override
    public boolean isModified() {
        return this.lastModified != new File(this.finalFileName).lastModified();
    }

    @Override
    public String getKey() {
        return this.fileName;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public String getFinalFileName() {
        return this.finalFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public StringBuilder getContent() {
        File file = new File(this.finalFileName);
        if (!file.exists()) {
            throw new RuntimeException("File not found : " + this.finalFileName);
        }
        this.lastModified = file.lastModified();
        return FileStringSource.loadFile(file, this.encoding);
    }

    private String buildFinalFileName(String baseTemplatePath, String fileName) {
        char firstChar = fileName.charAt(0);
        String finalFileName = firstChar == '/' || firstChar == '\\' ? baseTemplatePath + fileName : baseTemplatePath + File.separator + fileName;
        return finalFileName;
    }

    public static StringBuilder loadFile(File file, String encoding) {
        StringBuilder ret = new StringBuilder((int)file.length() + 3);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            String line = br.readLine();
            if (line != null) {
                ret.append(line);
            } else {
                StringBuilder stringBuilder = ret;
                return stringBuilder;
            }
            while ((line = br.readLine()) != null) {
                ret.append("\n").append(line);
            }
            StringBuilder stringBuilder = ret;
            return stringBuilder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File name: ").append(this.fileName).append("\n");
        sb.append("Final file name: ").append(this.finalFileName).append("\n");
        sb.append("Last modified: ").append(this.lastModified).append("\n");
        return sb.toString();
    }
}

