/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.kit.StrKit;
import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.FileStringSource;
import com.jfinal.template.IOutputDirectiveFactory;
import com.jfinal.template.IStringSource;
import com.jfinal.template.MemoryStringSource;
import com.jfinal.template.OutputDirectiveFactory;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.SharedMethodKit;
import com.jfinal.template.ext.directive.DateDirective;
import com.jfinal.template.ext.directive.EscapeDirective;
import com.jfinal.template.ext.directive.RandomDirective;
import com.jfinal.template.ext.directive.RenderDirective;
import com.jfinal.template.ext.directive.StringDirective;
import com.jfinal.template.ext.sharedmethod.Json;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.Parser;
import com.jfinal.template.stat.ast.Define;
import com.jfinal.template.stat.ast.Output;
import com.jfinal.template.stat.ast.Stat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineConfig {
    private Map<String, Define> sharedFunctionMap = new HashMap<String, Define>();
    private List<IStringSource> sharedFunctionSourceList = new ArrayList<IStringSource>();
    Map<String, Object> sharedObjectMap = null;
    private IOutputDirectiveFactory outputDirectiveFactory = OutputDirectiveFactory.me;
    private Map<String, Stat> directiveMap = new HashMap<String, Stat>();
    private SharedMethodKit sharedMethodKit = new SharedMethodKit();
    private boolean devMode = false;
    private boolean reloadModifiedSharedFunctionInDevMode = true;
    private String baseTemplatePath = null;
    private String encoding = "UTF-8";
    private String datePattern = "yyyy-MM-dd HH:mm";

    public EngineConfig() {
        this.addDirective("render", new RenderDirective());
        this.addDirective("date", new DateDirective());
        this.addDirective("escape", new EscapeDirective());
        this.addDirective("string", new StringDirective());
        this.addDirective("random", new RandomDirective());
        this.addSharedMethod(new Json());
    }

    public void addSharedFunction(String fileName) {
        FileStringSource fileStringSource = new FileStringSource(this.baseTemplatePath, fileName, this.encoding);
        this.doAddSharedFunction(fileStringSource, fileName);
    }

    private synchronized void doAddSharedFunction(IStringSource stringSource, String fileName) {
        Env env = new Env(this);
        new Parser(env, stringSource.getContent(), fileName).parse();
        this.addToSharedFunctionMap(this.sharedFunctionMap, env);
        if (this.devMode) {
            this.sharedFunctionSourceList.add(stringSource);
            env.addStringSource(stringSource);
        }
    }

    public void addSharedFunction(String ... fileNames) {
        for (String fileName : fileNames) {
            this.addSharedFunction(fileName);
        }
    }

    public void addSharedFunctionByString(String content) {
        MemoryStringSource memoryStringSource = new MemoryStringSource(content);
        this.doAddSharedFunction(memoryStringSource, null);
    }

    public void addSharedFunction(IStringSource stringSource) {
        String fileName = stringSource instanceof FileStringSource ? ((FileStringSource)stringSource).getFileName() : null;
        this.doAddSharedFunction(stringSource, fileName);
    }

    private void addToSharedFunctionMap(Map<String, Define> sharedFunctionMap, Env env) {
        Map<String, Define> funcMap = env.getFunctionMap();
        for (Map.Entry<String, Define> e : funcMap.entrySet()) {
            if (sharedFunctionMap.containsKey(e.getKey())) {
                throw new IllegalArgumentException("Template function already exists : " + e.getKey());
            }
            Define func = e.getValue();
            if (this.devMode) {
                func.setEnvForDevMode(env);
            }
            sharedFunctionMap.put(e.getKey(), func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Define getSharedFunction(String functionName) {
        Define func = this.sharedFunctionMap.get(functionName);
        if (func == null) {
            return null;
        }
        if (this.devMode && this.reloadModifiedSharedFunctionInDevMode && func.isSourceModifiedForDevMode()) {
            EngineConfig engineConfig = this;
            synchronized (engineConfig) {
                func = this.sharedFunctionMap.get(functionName);
                if (func.isSourceModifiedForDevMode()) {
                    this.reloadSharedFunctionSourceList();
                    func = this.sharedFunctionMap.get(functionName);
                }
            }
        }
        return func;
    }

    private synchronized void reloadSharedFunctionSourceList() {
        HashMap<String, Define> newMap = new HashMap<String, Define>();
        int size = this.sharedFunctionSourceList.size();
        for (int i = 0; i < size; ++i) {
            IStringSource ss = this.sharedFunctionSourceList.get(i);
            String fileName = ss instanceof FileStringSource ? ((FileStringSource)ss).getFileName() : null;
            Env env = new Env(this);
            new Parser(env, ss.getContent(), fileName).parse();
            this.addToSharedFunctionMap(newMap, env);
            if (!this.devMode) continue;
            env.addStringSource(ss);
        }
        this.sharedFunctionMap = newMap;
    }

    public synchronized void addSharedObject(String name, Object object) {
        if (this.sharedObjectMap == null) {
            this.sharedObjectMap = new HashMap<String, Object>();
        } else if (this.sharedObjectMap.containsKey(name)) {
            throw new IllegalArgumentException("Shared object already exists: " + name);
        }
        this.sharedObjectMap.put(name, object);
    }

    Map<String, Object> getSharedObjectMap() {
        return this.sharedObjectMap;
    }

    public void setOutputDirectiveFactory(IOutputDirectiveFactory outputDirectiveFactory) {
        if (outputDirectiveFactory == null) {
            throw new IllegalArgumentException("outputDirectiveFactory can not be null");
        }
        this.outputDirectiveFactory = outputDirectiveFactory;
    }

    public Output getOutputDirective(ExprList exprList, Location location) {
        return this.outputDirectiveFactory.getOutputDirective(exprList, location);
    }

    void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setBaseTemplatePath(String baseTemplatePath) {
        if (StrKit.isBlank(baseTemplatePath)) {
            throw new IllegalArgumentException("baseTemplatePath can not be blank");
        }
        if ((baseTemplatePath = baseTemplatePath.trim()).length() > 1 && (baseTemplatePath.endsWith("/") || baseTemplatePath.endsWith("\\"))) {
            baseTemplatePath = baseTemplatePath.substring(0, baseTemplatePath.length() - 1);
        }
        this.baseTemplatePath = baseTemplatePath;
    }

    public String getBaseTemplatePath() {
        return this.baseTemplatePath;
    }

    public void setEncoding(String encoding) {
        if (StrKit.isBlank(encoding)) {
            throw new IllegalArgumentException("encoding can not be blank");
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank");
        }
        this.datePattern = datePattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setReloadModifiedSharedFunctionInDevMode(boolean reloadModifiedSharedFunctionInDevMode) {
        this.reloadModifiedSharedFunctionInDevMode = reloadModifiedSharedFunctionInDevMode;
    }

    public synchronized void addDirective(String directiveName, Directive directive) {
        if (StrKit.isBlank(directiveName)) {
            throw new IllegalArgumentException("directive name can not be blank");
        }
        if (directive == null) {
            throw new IllegalArgumentException("directive can not be null");
        }
        if (this.directiveMap.containsKey(directiveName)) {
            throw new IllegalArgumentException("directive already exists : " + directiveName);
        }
        this.directiveMap.put(directiveName, directive);
    }

    public Stat getDirective(String directiveName) {
        return this.directiveMap.get(directiveName);
    }

    public void removeDirective(String directiveName) {
        this.directiveMap.remove(directiveName);
    }

    public void addSharedMethod(Object sharedMethodFromObject) {
        this.sharedMethodKit.addSharedMethod(sharedMethodFromObject);
    }

    public void addSharedStaticMethod(Class<?> sharedClass) {
        this.sharedMethodKit.addSharedStaticMethod(sharedClass);
    }

    public void removeSharedMethod(String methodName) {
        this.sharedMethodKit.removeSharedMethod(methodName);
    }

    public void removeSharedMethod(Class<?> sharedClass) {
        this.sharedMethodKit.removeSharedMethod(sharedClass);
    }

    public void removeSharedMethod(Method method) {
        this.sharedMethodKit.removeSharedMethod(method);
    }

    public SharedMethodKit getSharedMethodKit() {
        return this.sharedMethodKit;
    }
}

