/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Directive;
import com.jfinal.template.EngineConfig;
import com.jfinal.template.Env;
import com.jfinal.template.FileStringSource;
import com.jfinal.template.IOutputDirectiveFactory;
import com.jfinal.template.IStringSource;
import com.jfinal.template.MemoryStringSource;
import com.jfinal.template.Template;
import com.jfinal.template.stat.Parser;
import com.jfinal.template.stat.ast.Stat;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Engine {
    public static final String MAIN_ENGINE_NAME = "main";
    private static Engine MAIN_ENGINE;
    private static Map<String, Engine> engineMap;
    private String name;
    private boolean devMode = false;
    private EngineConfig config = new EngineConfig();
    private Map<String, Template> templateCache = new HashMap<String, Template>();

    public Engine() {
        this.name = "NO_NAME";
    }

    public Engine(String engineName) {
        this.name = engineName;
    }

    public static Engine use() {
        return MAIN_ENGINE;
    }

    public static Engine use(String engineName) {
        return engineMap.get(engineName);
    }

    public static synchronized Engine create(String engineName) {
        if (StrKit.isBlank(engineName)) {
            throw new IllegalArgumentException("Engine name can not be blank");
        }
        if (engineMap.containsKey(engineName = engineName.trim())) {
            throw new IllegalArgumentException("Engine already exists : " + engineName);
        }
        Engine newEngine = new Engine(engineName);
        engineMap.put(engineName, newEngine);
        return newEngine;
    }

    public static synchronized Engine remove(String engineName) {
        Engine removed = engineMap.remove(engineName);
        if (removed != null && MAIN_ENGINE_NAME.equals(removed.name)) {
            MAIN_ENGINE = null;
        }
        return removed;
    }

    public static synchronized void setMainEngine(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Engine can not be null");
        }
        engine.name = MAIN_ENGINE_NAME;
        engineMap.put(MAIN_ENGINE_NAME, engine);
        MAIN_ENGINE = engine;
    }

    public Template getTemplate(String fileName) {
        Template template;
        if (fileName.charAt(0) != '/') {
            char[] arr = new char[fileName.length() + 1];
            fileName.getChars(0, fileName.length(), arr, 1);
            arr[0] = 47;
            fileName = new String(arr);
        }
        if ((template = this.templateCache.get(fileName)) == null) {
            template = this.buildTemplateByFileStringSource(fileName);
            this.templateCache.put(fileName, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateByFileStringSource(fileName);
            this.templateCache.put(fileName, template);
        }
        return template;
    }

    private Template buildTemplateByFileStringSource(String fileName) {
        FileStringSource fileStringSource = new FileStringSource(this.config.getBaseTemplatePath(), fileName, this.config.getEncoding());
        Env env = new Env(this.config);
        Parser parser = new Parser(env, fileStringSource.getContent(), fileName);
        if (this.devMode) {
            env.addStringSource(fileStringSource);
        }
        Stat stat = parser.parse();
        Template template = new Template(env, stat);
        return template;
    }

    public Template getTemplateByString(String content) {
        String key = HashKit.md5(content);
        Template template = this.templateCache.get(key);
        if (template == null) {
            template = this.buildTemplateByStringSource(new MemoryStringSource(content));
            this.templateCache.put(key, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateByStringSource(new MemoryStringSource(content));
            this.templateCache.put(key, template);
        }
        return template;
    }

    public Template getTemplate(IStringSource stringSource) {
        String key = stringSource.getKey();
        Template template = this.templateCache.get(key);
        if (template == null) {
            template = this.buildTemplateByStringSource(stringSource);
            this.templateCache.put(key, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateByStringSource(stringSource);
            this.templateCache.put(key, template);
        }
        return template;
    }

    private Template buildTemplateByStringSource(IStringSource stringSource) {
        Env env = new Env(this.config);
        Parser parser = new Parser(env, stringSource.getContent(), null);
        if (this.devMode) {
            env.addStringSource(stringSource);
        }
        Stat stat = parser.parse();
        Template template = new Template(env, stat);
        return template;
    }

    public Engine addSharedFunction(String fileName) {
        this.config.addSharedFunction(fileName);
        return this;
    }

    public Engine addSharedFunction(IStringSource stringSource) {
        this.config.addSharedFunction(stringSource);
        return this;
    }

    public Engine addSharedFunction(String ... fileNames) {
        this.config.addSharedFunction(fileNames);
        return this;
    }

    public Engine addSharedFunctionByString(String content) {
        this.config.addSharedFunctionByString(content);
        return this;
    }

    public Engine addSharedObject(String name, Object object) {
        this.config.addSharedObject(name, object);
        return this;
    }

    public Engine setOutputDirectiveFactory(IOutputDirectiveFactory outputDirectiveFactory) {
        this.config.setOutputDirectiveFactory(outputDirectiveFactory);
        return this;
    }

    public Engine addDirective(String directiveName, Directive directive) {
        this.config.addDirective(directiveName, directive);
        return this;
    }

    public Engine removeDirective(String directiveName) {
        this.config.removeDirective(directiveName);
        return this;
    }

    public Engine addSharedMethod(Object sharedMethodFromObject) {
        this.config.addSharedMethod(sharedMethodFromObject);
        return this;
    }

    public Engine addSharedStaticMethod(Class<?> sharedClass) {
        this.config.addSharedStaticMethod(sharedClass);
        return this;
    }

    public Engine removeSharedMethod(String methodName) {
        this.config.removeSharedMethod(methodName);
        return this;
    }

    public Engine removeSharedMethod(Class<?> clazz) {
        this.config.removeSharedMethod(clazz);
        return this;
    }

    public Engine removeSharedMethod(Method method) {
        this.config.removeSharedMethod(method);
        return this;
    }

    public void removeTemplateCache(String templateKey) {
        this.templateCache.remove(templateKey);
    }

    public void removeAllTemplateCache() {
        this.templateCache.clear();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Template Engine: " + this.name;
    }

    public EngineConfig getEngineConfig() {
        return this.config;
    }

    public Engine setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.config.setDevMode(devMode);
        if (this.devMode) {
            this.removeAllTemplateCache();
        }
        return this;
    }

    public boolean getDevMode() {
        return this.devMode;
    }

    public Engine setBaseTemplatePath(String baseTemplatePath) {
        this.config.setBaseTemplatePath(baseTemplatePath);
        return this;
    }

    public String getBaseTemplatePath() {
        return this.config.getBaseTemplatePath();
    }

    public Engine setDatePattern(String datePattern) {
        this.config.setDatePattern(datePattern);
        return this;
    }

    public String getDatePattern() {
        return this.config.getDatePattern();
    }

    public Engine setEncoding(String encoding) {
        this.config.setEncoding(encoding);
        return this;
    }

    public String getEncoding() {
        return this.config.getEncoding();
    }

    public Engine setReloadModifiedSharedFunctionInDevMode(boolean reloadModifiedSharedFunctionInDevMode) {
        this.config.setReloadModifiedSharedFunctionInDevMode(reloadModifiedSharedFunctionInDevMode);
        return this;
    }

    static {
        engineMap = new HashMap<String, Engine>();
        MAIN_ENGINE = new Engine(MAIN_ENGINE_NAME);
        engineMap.put(MAIN_ENGINE_NAME, MAIN_ENGINE);
    }
}

