/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.template.Engine;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;

public class TemplateRender
extends Render {
    private static Engine engine;
    private static final String contentType;

    static void init(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine can not be null");
        }
        TemplateRender.engine = engine;
    }

    public TemplateRender(String view) {
        this.view = view;
    }

    public String getContentType() {
        return contentType;
    }

    @Override
    public void render() {
        this.response.setContentType(this.getContentType());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            data.put(attrName, this.request.getAttribute(attrName));
        }
        PrintWriter writer = null;
        try {
            writer = this.response.getWriter();
            engine.getTemplate(this.view).render(data, writer);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public String toString() {
        return this.view;
    }

    static {
        contentType = "text/html; charset=" + TemplateRender.getEncoding();
    }
}

