/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.ehcache.CacheName;
import com.jfinal.plugin.ehcache.RenderInfo;
import com.jfinal.render.Render;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;

public class CacheInterceptor
implements Interceptor {
    private static final String renderKey = "_renderKey";
    private static ConcurrentHashMap<String, ReentrantLock> lockMap = new ConcurrentHashMap();

    private ReentrantLock getLock(String key) {
        ReentrantLock lock = lockMap.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock previousLock = lockMap.putIfAbsent(key, lock);
        return previousLock == null ? lock : previousLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void intercept(Invocation inv) {
        String cacheKey;
        Controller controller = inv.getController();
        String cacheName = this.buildCacheName(inv, controller);
        Map cacheData = (Map)CacheKit.get(cacheName, cacheKey = this.buildCacheKey(inv, controller));
        if (cacheData == null) {
            ReentrantLock lock = this.getLock(cacheName);
            lock.lock();
            try {
                cacheData = (Map)CacheKit.get(cacheName, cacheKey);
                if (cacheData == null) {
                    inv.invoke();
                    this.cacheAction(cacheName, cacheKey, controller);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        this.useCacheDataAndRender(cacheData, controller);
    }

    protected String buildCacheName(Invocation inv, Controller controller) {
        CacheName cacheName = inv.getMethod().getAnnotation(CacheName.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = controller.getClass().getAnnotation(CacheName.class);
        return cacheName != null ? cacheName.value() : inv.getActionKey();
    }

    protected String buildCacheKey(Invocation inv, Controller controller) {
        String queryString;
        StringBuilder sb = new StringBuilder(inv.getActionKey());
        String urlPara = controller.getPara();
        if (urlPara != null) {
            sb.append("/").append(urlPara);
        }
        if ((queryString = controller.getRequest().getQueryString()) != null) {
            sb.append("?").append(queryString);
        }
        return sb.toString();
    }

    protected RenderInfo createRenderInfo(Render render) {
        return new RenderInfo(render);
    }

    protected void cacheAction(String cacheName, String cacheKey, Controller controller) {
        HttpServletRequest request = controller.getRequest();
        HashMap<String, Object> cacheData = new HashMap<String, Object>();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            cacheData.put(name, request.getAttribute(name));
        }
        Render render = controller.getRender();
        if (render != null) {
            cacheData.put(renderKey, this.createRenderInfo(render));
        }
        CacheKit.put(cacheName, cacheKey, cacheData);
    }

    protected void useCacheDataAndRender(Map<String, Object> cacheData, Controller controller) {
        HttpServletRequest request = controller.getRequest();
        Set<Map.Entry<String, Object>> set = cacheData.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        request.removeAttribute(renderKey);
        RenderInfo renderInfo = (RenderInfo)cacheData.get(renderKey);
        if (renderInfo != null) {
            controller.render(renderInfo.createRender());
        }
    }
}

