/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.tx.Tx;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class TxByMethodRegex
implements Interceptor {
    private Pattern pattern;

    public TxByMethodRegex(String regex) {
        this(regex, true);
    }

    public TxByMethodRegex(String regex, boolean caseSensitive) {
        if (StrKit.isBlank(regex)) {
            throw new IllegalArgumentException("regex can not be blank.");
        }
        this.pattern = caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2);
    }

    @Override
    public void intercept(final Invocation inv) {
        Config config = Tx.getConfigWithTxConfig(inv);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if (this.pattern.matcher(inv.getMethodName()).matches()) {
            DbPro.use(config.getName()).tx(new IAtom(){

                @Override
                public boolean run() throws SQLException {
                    inv.invoke();
                    return true;
                }
            });
        } else {
            inv.invoke();
        }
    }
}

