/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Constants;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Config;
import com.jfinal.core.JFinal;
import com.jfinal.handler.Handler;
import com.jfinal.log.Log;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JFinalFilter
implements Filter {
    private Handler handler;
    private String encoding;
    private JFinalConfig jfinalConfig;
    private Constants constants;
    private static final JFinal jfinal = JFinal.me();
    private static Log log;
    private int contextPathLength;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.createJFinalConfig(filterConfig.getInitParameter("configClass"));
        if (!jfinal.init(this.jfinalConfig, filterConfig.getServletContext())) {
            throw new RuntimeException("JFinal init error!");
        }
        this.handler = jfinal.getHandler();
        this.constants = Config.getConstants();
        this.encoding = this.constants.getEncoding();
        this.jfinalConfig.afterJFinalStart();
        String contextPath = filterConfig.getServletContext().getContextPath();
        this.contextPathLength = contextPath == null || "/".equals(contextPath) ? 0 : contextPath.length();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean[] isHandled;
        HttpServletResponse response;
        HttpServletRequest request;
        block4: {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
            request.setCharacterEncoding(this.encoding);
            String target = request.getRequestURI();
            if (this.contextPathLength != 0) {
                target = target.substring(this.contextPathLength);
            }
            isHandled = new boolean[]{false};
            try {
                this.handler.handle(target, request, response, isHandled);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                String qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, e);
            }
        }
        if (!isHandled[0]) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
        this.jfinalConfig.beforeJFinalStop();
        jfinal.stopPlugins();
    }

    private void createJFinalConfig(String configClass) {
        if (configClass == null) {
            throw new RuntimeException("Please set configClass parameter of JFinalFilter in web.xml");
        }
        Object temp = null;
        try {
            temp = Class.forName(configClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create instance of class: " + configClass, e);
        }
        if (!(temp instanceof JFinalConfig)) {
            throw new RuntimeException("Can not create instance of class: " + configClass + ". Please check the config in web.xml");
        }
        this.jfinalConfig = temp;
    }

    static void initLog() {
        log = Log.getLog(JFinalFilter.class);
    }
}

