/*
 * Decompiled with CFR 0.152.
 */
package com.jexbox.connector.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jexbox.connector.JexboxConnectorImpl;
import com.jexbox.connector.TransportException;
import com.jexbox.connector.http.JexboxConnectorHttp;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexboxConnectorHttpImpl
extends JexboxConnectorImpl
implements JexboxConnectorHttp {
    private static Logger _logger = Logger.getLogger(JexboxConnectorHttpImpl.class.getName());

    public JexboxConnectorHttpImpl(Properties props) {
        super(props);
    }

    @Override
    public void send(Throwable e, HttpServletRequest request) {
        this.sendWithMeta(e, request, null);
    }

    @Override
    public void sendWithMeta(Throwable e, HttpServletRequest request, Map<String, Map<String, String>> metaD) {
        try {
            JsonObject json = this.json(e, metaD);
            this.addRequestMetaData(request, json);
            HttpSession session = request.getSession(false);
            this.addSessionMetaData(session, json);
            this._notifier.send(json);
        }
        catch (UnsupportedEncodingException e1) {
            _logger.log(Level.SEVERE, "Could not able to send error to Jexbox", e1);
        }
        catch (TransportException e1) {
            _logger.log(Level.SEVERE, "Could not able to send error to Jexbox", e1);
        }
    }

    protected void addSessionMetaData(HttpSession session, JsonObject json) {
        if (session != null) {
            JsonObject meta = json.getAsJsonObject("meta");
            if (meta == null) {
                meta = new JsonObject();
                json.add("meta", (JsonElement)meta);
            }
            JsonObject sessionD = new JsonObject();
            meta.add("Session", (JsonElement)sessionD);
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object attr = session.getAttribute(name);
                sessionD.add(name, (JsonElement)new JsonPrimitive(String.valueOf(attr)));
            }
        }
    }

    protected void addRequestMetaData(HttpServletRequest reqHTTP, JsonObject json) {
        JsonObject meta = json.getAsJsonObject("meta");
        if (meta == null) {
            meta = new JsonObject();
            json.add("meta", (JsonElement)meta);
        }
        json.add("uri", (JsonElement)new JsonPrimitive(reqHTTP.getRequestURL().toString()));
        JsonObject reqAttr = new JsonObject();
        meta.add("Request Attr", (JsonElement)reqAttr);
        Enumeration names = reqHTTP.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object attr = reqHTTP.getAttribute(name);
            if (attr != null) {
                reqAttr.add(name, (JsonElement)new JsonPrimitive(String.valueOf(attr)));
                continue;
            }
            reqAttr.add(name, (JsonElement)new JsonPrimitive("null"));
        }
        JsonObject reqPara = new JsonObject();
        meta.add("Request Params", (JsonElement)reqPara);
        names = reqHTTP.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String attr = reqHTTP.getParameter(name);
            if (attr != null) {
                reqPara.add(name, (JsonElement)new JsonPrimitive(String.valueOf(attr)));
                continue;
            }
            reqPara.add(name, (JsonElement)new JsonPrimitive("null"));
        }
        JsonObject reqHead = new JsonObject();
        meta.add("Request Headers", (JsonElement)reqHead);
        names = reqHTTP.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String attr = reqHTTP.getHeader(name);
            if (attr != null) {
                reqHead.add(name, (JsonElement)new JsonPrimitive(String.valueOf(attr)));
                continue;
            }
            reqHead.add(name, (JsonElement)new JsonPrimitive("null"));
        }
        JsonObject req = new JsonObject();
        meta.add("Request", (JsonElement)req);
        req.add("Auth Type", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getAuthType())));
        req.add("Character Encoding", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getCharacterEncoding())));
        req.add("Content Type", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getContentType())));
        req.add("Context Path", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getContextPath())));
        req.add("Local Addr", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getLocalAddr())));
        req.add("Local Name", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getLocalName())));
        req.add("Method", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getMethod())));
        req.add("Path Info", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getPathInfo())));
        req.add("Path Translated", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getPathTranslated())));
        req.add("Protocol", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getProtocol())));
        req.add("Query String", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getQueryString())));
        req.add("Remote Addr", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getRemoteAddr())));
        req.add("Remote Host", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getRemoteHost())));
        req.add("Remote User", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getRemoteUser())));
        req.add("Requested Session Id", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getRequestedSessionId())));
        req.add("Request URI", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getRequestURI())));
        req.add("Scheme", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getScheme())));
        req.add("Server Name", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getServerName())));
        req.add("Servlet Path", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getServletPath())));
        req.add("Content Length", (JsonElement)new JsonPrimitive(String.valueOf(reqHTTP.getContentLength())));
    }
}

