/*
 * Decompiled with CFR 0.152.
 */
package com.jexbox.connector;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jexbox.connector.MemoryQueue;
import com.jexbox.connector.TransportException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transport
implements Runnable {
    private static Logger _logger = Logger.getLogger(Transport.class.getName());
    private MemoryQueue _queue = null;
    private String _state = "idle";

    public Transport(MemoryQueue queue) {
        this._queue = queue;
    }

    public synchronized void stop() {
        this._state = "stop";
        this._queue.notifyWorker();
    }

    public synchronized void start() {
        if (!"idle".equals(this._state)) {
            _logger.log(Level.INFO, "You can only start idle workers");
            return;
        }
        Thread t = new Thread(this);
        t.setDaemon(true);
        this._state = "running";
        t.start();
    }

    public synchronized String getState() {
        return this._state;
    }

    public void run() {
        while (!"stop".equalsIgnoreCase(this._state)) {
            JsonObject json = this._queue.peek();
            if (json == null) {
                this._queue.waitWorker();
                continue;
            }
            try {
                Transport.send(json);
            }
            catch (Throwable e) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this._queue.remove();
        }
    }

    public static void send(JsonObject json) throws TransportException, UnsupportedEncodingException {
        String appId = json.get("appId").getAsString();
        JsonElement jh = json.remove("host");
        String host = jh != null ? jh.getAsString() : null;
        JsonElement jph = json.remove("proxyHost");
        String proxyHost = jph != null ? jph.getAsString() : null;
        JsonElement jp = json.remove("proxyPort");
        int port = jp != null ? Integer.valueOf(jp.getAsInt()) : null;
        JsonElement jusp = json.remove("useSystemProxy");
        boolean useSystemProxy = jusp != null ? Boolean.valueOf(jusp.getAsBoolean()) : null;
        Transport.send(host, proxyHost, port, useSystemProxy, json.toString(), "application/json", appId);
    }

    public static void send(String host, String proxyHost, int port, boolean useSystemProxy, JsonObject json, String appId) throws TransportException, UnsupportedEncodingException {
        Transport.send(host, proxyHost, port, useSystemProxy, json.toString(), "application/json", appId);
    }

    public static void send(String host, String proxyHost, int port, boolean useSystemProxy, InputStream is, String appId) throws TransportException, UnsupportedEncodingException {
        Transport.send(host, proxyHost, port, useSystemProxy, is, "application/json", appId);
    }

    public static void send(String host, String proxyHost, int port, boolean useSystemProxy, String data, String ct, String appId) throws TransportException, UnsupportedEncodingException {
        Transport.send(host, proxyHost, port, useSystemProxy, new ByteArrayInputStream(data.getBytes("UTF-8")), ct, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String host, String proxyHost, int port, boolean useSystemProxy, InputStream data, String ct, String appId) throws TransportException {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(host);
            if (proxyHost != null && proxyHost.length() > 0) {
                InetSocketAddress addr = new InetSocketAddress(proxyHost, port);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                Proxy proxy;
                conn = useSystemProxy ? ((proxy = Transport.getSystemProxy(url.toURI())) != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection()) : (HttpURLConnection)url.openConnection();
            }
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            if (ct != null) {
                conn.addRequestProperty("Content-Type", ct);
            }
            conn.addRequestProperty("Authorization", appId);
            OutputStream out = null;
            try {
                int bytesRead;
                out = conn.getOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = data.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            int status = conn.getResponseCode();
            if (status / 100 != 2) {
                throw new TransportException(host);
            }
        }
        catch (IOException e) {
            throw new TransportException(String.format("Connection error while sending data to %s", host), e);
        }
        catch (URISyntaxException e) {
            throw new TransportException(String.format("Connection error while sending data to %s", host), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static Proxy getSystemProxy(URI host) {
        System.setProperty("java.net.useSystemProxies", "true");
        List<Proxy> list = ProxySelector.getDefault().select(host);
        Proxy proxy = null;
        if (list != null && list.size() > 0) {
            proxy = list.get(0);
        }
        return proxy;
    }
}

