/*
 * Decompiled with CFR 0.152.
 */
package com.jexbox.connector;

import com.google.gson.JsonObject;
import com.jexbox.connector.CAbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryQueue
extends CAbstractQueue {
    private static Logger _logger = Logger.getLogger(MemoryQueue.class.getName());
    private LinkedList<JsonObject> _queue = new LinkedList();

    protected synchronized Class<JsonObject> getPersistentClass() {
        return JsonObject.class;
    }

    @Override
    public synchronized int size() {
        return this._queue.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this._queue.contains(o);
    }

    public synchronized List<JsonObject> all() {
        return new ArrayList<JsonObject>(this._queue);
    }

    @Override
    public synchronized Iterator<JsonObject> iterator() {
        return this.all().iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.all().toArray();
    }

    @Override
    public synchronized <JsonObject> JsonObject[] toArray(JsonObject[] a) {
        return this.all().toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException("The SQL queue do not support null JsonObjects");
        }
        if (!(o instanceof JsonObject)) {
            throw new IllegalArgumentException("The removed object is not instance of JsonObject");
        }
        JsonObject JsonObject2 = (JsonObject)o;
        return this._queue.remove(JsonObject2);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this._queue.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends JsonObject> c) {
        boolean res = this._queue.addAll(c);
        this.notifyAll();
        return res;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this._queue.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported by Memory queue");
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException("Not supported by Memory queue");
    }

    @Override
    public synchronized boolean add(JsonObject e) {
        return this.offer(e);
    }

    @Override
    public synchronized boolean offer(JsonObject JsonObject2) {
        if (JsonObject2 == null) {
            throw new NullPointerException("The Memory queue do not support null JsonObjects");
        }
        boolean res = this._queue.offer(JsonObject2);
        this.notifyAll();
        return res;
    }

    @Override
    public synchronized JsonObject remove() {
        JsonObject JsonObject2 = this.poll();
        if (JsonObject2 == null) {
            throw new NoSuchElementException("The memory queue is empty or there is issue with database");
        }
        return JsonObject2;
    }

    @Override
    public synchronized JsonObject poll() {
        return this._queue.poll();
    }

    @Override
    public synchronized JsonObject element() {
        JsonObject JsonObject2 = this.peek();
        if (JsonObject2 == null) {
            throw new NoSuchElementException("The memory queue is empty or there is issue with database");
        }
        return JsonObject2;
    }

    @Override
    public synchronized JsonObject peek() {
        return this._queue.peek();
    }

    @Override
    public synchronized void waitWorker() {
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            _logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public synchronized void notifyWorker() {
        this.notifyAll();
    }
}

