/*
 * Decompiled with CFR 0.152.
 */
package com.jexbox.connector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jexbox.connector.BackgroundNotifier;
import com.jexbox.connector.JexboxConnector;
import com.jexbox.connector.Notifier;
import com.jexbox.connector.Transport;
import com.jexbox.connector.TransportException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexboxConnectorImpl
implements Notifier,
JexboxConnector {
    private static Logger _logger = Logger.getLogger(JexboxConnectorImpl.class.getName());
    public static final String NOTIFIER_URL = "https://jexbox.com/connectors";
    public static final String NOTIFIER_NAME = "Java Jexbox Notifier";
    public static final String NOTIFIER_VERSION = "0.0.1";
    public static final String ENVIRONMENT = "production";
    public static final String DEFAULT_HOST = "jexbox.com/api/notify";
    protected String name;
    protected String version;
    protected String url;
    protected String env;
    protected String appVersion;
    protected String appId;
    protected boolean ssl;
    protected String host;
    protected Notifier _notifier;
    protected String proxyHost;
    protected int proxyPort;
    protected boolean useSystemProxy;

    public JexboxConnectorImpl(Properties props) {
        this.init(props);
    }

    private void init(Properties props) {
        Boolean usp;
        boolean background;
        this.name = NOTIFIER_NAME;
        this.version = NOTIFIER_VERSION;
        this.url = NOTIFIER_URL;
        this.env = ENVIRONMENT;
        this.appVersion = NOTIFIER_VERSION;
        this.ssl = true;
        this.host = DEFAULT_HOST;
        this._notifier = this;
        this.proxyHost = null;
        this.useSystemProxy = false;
        this.appId = (String)props.get("appId");
        if (props.containsKey("host")) {
            this.host = (String)props.get("host");
        }
        if (props.containsKey("environment")) {
            this.env = (String)props.get("environment");
        }
        if (props.containsKey("ssl")) {
            this.ssl = Boolean.parseBoolean((String)props.get("ssl"));
        }
        if (props.containsKey("appVersion")) {
            this.appVersion = (String)props.get("appVersion");
        }
        if (props.containsKey("background") && (background = Boolean.parseBoolean((String)props.get("background")))) {
            this._notifier = new BackgroundNotifier();
        }
        this.proxyHost = (String)props.get("proxyHost");
        Integer pp = (Integer)props.get("proxyPort");
        if (pp != null) {
            this.proxyPort = pp;
        }
        if ((usp = (Boolean)props.get("useSystemProxy")) != null) {
            this.useSystemProxy = usp;
        }
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public void send(JsonObject json) throws TransportException, UnsupportedEncodingException {
        Transport.send(json);
    }

    @Override
    public void send(Throwable e) {
        this.sendWithMeta(e, null);
    }

    @Override
    public void sendWithMeta(Throwable e, Map<String, Map<String, String>> metaD) {
        JsonObject json = this.json(e, metaD);
        this.sendJson(json);
    }

    @Override
    public void sendJson(JsonObject json) {
        try {
            this._notifier.send(json);
        }
        catch (UnsupportedEncodingException e1) {
            _logger.log(Level.SEVERE, "Could not able to send error to Jexbox", e1);
        }
        catch (TransportException e1) {
            _logger.log(Level.SEVERE, "Could not able to send error to Jexbox", e1);
        }
    }

    @Override
    public JsonObject json(Throwable e) {
        return this.json(e, null);
    }

    @Override
    public JsonObject json(Throwable e, Map<String, Map<String, String>> metaD) {
        JsonObject json = new JsonObject();
        json.add("appId", (JsonElement)new JsonPrimitive(this.getAppId()));
        json.add("host", (JsonElement)new JsonPrimitive(this.getHttpHost()));
        json.add("appVersion", (JsonElement)new JsonPrimitive(this.getAppVersion()));
        if (this.getProxyHost() != null) {
            json.add("proxyHost", (JsonElement)new JsonPrimitive(this.getProxyHost()));
        }
        json.add("proxyPort", (JsonElement)new JsonPrimitive((Number)this.getProxyPort()));
        json.add("useSystemProxy", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.getUseSystemProxy())));
        JsonObject notifier = new JsonObject();
        json.add("notifier", (JsonElement)notifier);
        notifier.add("name", (JsonElement)new JsonPrimitive(this.getName()));
        notifier.add("version", (JsonElement)new JsonPrimitive(this.getVersion()));
        notifier.add("url", (JsonElement)new JsonPrimitive(this.getUrl()));
        notifier.add("env", (JsonElement)new JsonPrimitive(this.getEnv()));
        JsonArray exceptions = new JsonArray();
        json.add("exceptions", (JsonElement)exceptions);
        json.add("exceptionType", (JsonElement)new JsonPrimitive(e.getClass().getName()));
        json.add("inClass", (JsonElement)new JsonPrimitive(e.getStackTrace()[0].getClassName()));
        json.add("inMethod", (JsonElement)new JsonPrimitive(e.getStackTrace()[0].getMethodName()));
        json.add("inFile", (JsonElement)new JsonPrimitive(this.convertNull(e.getStackTrace()[0].getFileName())));
        json.add("onLine", (JsonElement)new JsonPrimitive((Number)e.getStackTrace()[0].getLineNumber()));
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            JsonObject jex = new JsonObject();
            exceptions.add((JsonElement)jex);
            jex.add("class", (JsonElement)new JsonPrimitive(ex.getClass().getName()));
            String message = ex.getMessage() == null || ex.getMessage().length() == 0 ? "" : ex.getMessage();
            jex.add("message", (JsonElement)new JsonPrimitive(message));
            JsonArray stack = new JsonArray();
            jex.add("stacktrace", (JsonElement)stack);
            StackTraceElement[] stackTrace = ex.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement el = stackTrace[i];
                stack.add((JsonElement)new JsonPrimitive(el.toString()));
            }
        }
        JsonObject meta = new JsonObject();
        json.add("meta", (JsonElement)meta);
        JsonObject env = this.getEnvironment();
        meta.add("Environment", (JsonElement)env);
        JsonObject systemProps = this.getSystemProps();
        meta.add("SystemProps", (JsonElement)systemProps);
        if (metaD != null) {
            for (String metaName : metaD.keySet()) {
                JsonObject metaP = new JsonObject();
                meta.add(metaName, (JsonElement)metaP);
                Map<String, String> metaG = metaD.get(metaName);
                for (String key : metaG.keySet()) {
                    String val = metaG.get(key);
                    metaP.add(key, (JsonElement)new JsonPrimitive(val));
                }
            }
        }
        return json;
    }

    protected String convertNull(String prop) {
        if (prop == null || prop.length() == 0) {
            prop = "undefined";
        }
        return prop;
    }

    protected JsonObject getEnvironment() {
        JsonObject env = new JsonObject();
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            env.add(key, (JsonElement)new JsonPrimitive(val));
        }
        return env;
    }

    protected JsonObject getSystemProps() {
        JsonObject env = new JsonObject();
        Set<Object> keys = System.getProperties().keySet();
        for (Object keyO : keys) {
            String key = keyO.toString();
            String val = System.getProperty(key);
            env.add(key, (JsonElement)new JsonPrimitive(val));
        }
        return env;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    private String getHttpHost() {
        return (this.ssl ? "https://" : "http://") + this.getHost();
    }

    @Override
    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean getUseSystemProxy() {
        return this.useSystemProxy;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }
}

