/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.ExampleTargetPlugin;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.internal.util.StringUtility;

public class IntrospectedTableTools {
    public static void setDomainObjectName(IntrospectedTable introspectedTable, Context context, String domainObjectName) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        introspectedTable.getTableConfiguration().setDomainObjectName(domainObjectName);
        Field domainObjectNameField = FullyQualifiedTable.class.getDeclaredField("domainObjectName");
        domainObjectNameField.setAccessible(true);
        domainObjectNameField.set(introspectedTable.getFullyQualifiedTable(), domainObjectName);
        Method calculateJavaClientAttributes = IntrospectedTable.class.getDeclaredMethod("calculateJavaClientAttributes", new Class[0]);
        calculateJavaClientAttributes.setAccessible(true);
        calculateJavaClientAttributes.invoke((Object)introspectedTable, new Object[0]);
        Method calculateModelAttributes = IntrospectedTable.class.getDeclaredMethod("calculateModelAttributes", new Class[0]);
        calculateModelAttributes.setAccessible(true);
        calculateModelAttributes.invoke((Object)introspectedTable, new Object[0]);
        Method calculateXmlAttributes = IntrospectedTable.class.getDeclaredMethod("calculateXmlAttributes", new Class[0]);
        calculateXmlAttributes.setAccessible(true);
        calculateXmlAttributes.invoke((Object)introspectedTable, new Object[0]);
        PluginConfiguration configuration = PluginTools.getPluginConfiguration(context, ExampleTargetPlugin.class);
        if (configuration != null && configuration.getProperty("targetPackage") != null) {
            String exampleType = introspectedTable.getExampleType();
            JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = context.getJavaModelGeneratorConfiguration();
            String targetPackage = javaModelGeneratorConfiguration.getTargetPackage();
            String newExampleType = exampleType.replace(targetPackage, configuration.getProperty("targetPackage"));
            introspectedTable.setExampleType(newExampleType);
        }
    }

    public static IntrospectedColumn safeGetColumn(IntrospectedTable introspectedTable, String columnName) {
        String endingDelimiter;
        columnName = columnName.trim();
        String beginningDelimiter = introspectedTable.getContext().getBeginningDelimiter();
        if (StringUtility.stringHasValue((String)beginningDelimiter)) {
            columnName = columnName.replaceFirst("^" + beginningDelimiter, "");
        }
        if (StringUtility.stringHasValue((String)(endingDelimiter = introspectedTable.getContext().getEndingDelimiter()))) {
            columnName = columnName.replaceFirst(endingDelimiter + "$", "");
        }
        return introspectedTable.getColumn(columnName);
    }
}

