/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.cache.memory;

import com.ibatis.db.sqlmap.SqlMapException;
import java.util.HashMap;
import java.util.Map;

public final class MemoryCacheLevel {
    private static Map cacheLevelMap = new HashMap();
    public static final MemoryCacheLevel WEAK = new MemoryCacheLevel("WEAK");
    public static final MemoryCacheLevel SOFT = new MemoryCacheLevel("SOFT");
    public static final MemoryCacheLevel STRONG = new MemoryCacheLevel("STRONG");
    private String referenceType;

    private MemoryCacheLevel(String string) {
        this.referenceType = string;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public static MemoryCacheLevel getByReferenceType(String string) {
        MemoryCacheLevel memoryCacheLevel = (MemoryCacheLevel)cacheLevelMap.get(string);
        if (memoryCacheLevel == null) {
            throw new SqlMapException("Error getting CacheLevel (reference type) for name: '" + string + "'.");
        }
        return memoryCacheLevel;
    }

    static {
        cacheLevelMap.put(MemoryCacheLevel.WEAK.referenceType, WEAK);
        cacheLevelMap.put(MemoryCacheLevel.SOFT.referenceType, SOFT);
        cacheLevelMap.put(MemoryCacheLevel.STRONG.referenceType, STRONG);
    }
}

