/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.cache;

import com.ibatis.db.sqlmap.ExecuteListener;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.cache.CacheController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CacheModel
implements ExecuteListener {
    private Object STATS_LOCK = new Object();
    private int requests = 0;
    private int hits = 0;
    private static final long NO_FLUSH_INTERVAL = -99999L;
    private String name;
    private String resourceName;
    private CacheController controller;
    private long flushInterval = -99999L;
    private long flushIntervalSeconds = -99999L;
    private long lastFlush = System.currentTimeMillis();
    private Set flushTriggerStatements = new HashSet();
    private Properties properties;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setControllerClassName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                throw new SqlMapException("Error instantiating cache controller for cache named '" + this.name + "' in resource '" + this.resourceName + "'.  Cause: The class for name '" + string + "' could not be found.");
            }
            this.controller = (CacheController)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SqlMapException("Error instantiating cache controller for cache named '" + this.name + "' in resource '" + this.resourceName + "'.  Cause: " + exception, exception);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public long getFlushIntervalSeconds() {
        return this.flushIntervalSeconds;
    }

    public void setFlushInterval(long l) {
        this.flushInterval = l;
        this.flushIntervalSeconds = l / 1000L;
    }

    public void addFlushTriggerStatement(String string) {
        this.flushTriggerStatements.add(string);
    }

    public Iterator getFlushTriggerStatements() {
        return this.flushTriggerStatements.iterator();
    }

    public void onExecuteStatement(MappedStatement mappedStatement) {
        this.flush();
    }

    public void flush() {
        this.lastFlush = System.currentTimeMillis();
        this.controller.flush(this);
    }

    public Object getObject(Object object) {
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            if (this.flushInterval != -99999L && System.currentTimeMillis() - this.lastFlush > this.flushInterval) {
                this.flush();
            }
        }
        Object object2 = this.controller.getObject(this, object);
        Object object3 = this.STATS_LOCK;
        synchronized (object3) {
            ++this.requests;
            if (object2 != null) {
                ++this.hits;
            }
        }
        return object2;
    }

    public void putObject(Object object, Object object2) {
        this.controller.putObject(this, object, object2);
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public void configureController(Properties properties) {
        try {
            this.properties = properties;
            this.controller.configure(properties);
        }
        catch (NullPointerException nullPointerException) {
            throw new SqlMapException("Error configuring controller named '" + this.name + "' in resource '" + this.resourceName + "'.  The controller is null.  Call setControllerClassName() with a valid value before attempting to configure the controller.", nullPointerException);
        }
        catch (Exception exception) {
            throw new SqlMapException("Error configuring controller named '" + this.name + "' in resource '" + this.resourceName + "'.  Cause: " + exception, exception);
        }
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }
}

