/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import chrriis.dj.nativeswing.NSSystemProperty;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObjectRegistry {
    private static Thread cleanUpThread;
    private static Set<ObjectRegistry> registrySet;
    private static int nextThreadNumber;
    private int nextInstanceID = 1;
    private Map<Integer, WeakReference<Object>> instanceIDToObjectReferenceMap = new HashMap<Integer, WeakReference<Object>>();
    private static ObjectRegistry registry;

    static {
        registrySet = new HashSet<ObjectRegistry>();
        registry = new ObjectRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startThread(ObjectRegistry objectRegistry) {
        Set<ObjectRegistry> set = registrySet;
        synchronized (set) {
            registrySet.add(objectRegistry);
            if (cleanUpThread != null) {
                return;
            }
            cleanUpThread = new Thread("Registry cleanup thread-" + nextThreadNumber++){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        ObjectRegistry[] registries;
                        try {
                            1.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Set set = registrySet;
                        synchronized (set) {
                            registries = registrySet.toArray(new ObjectRegistry[0]);
                        }
                        ObjectRegistry[] objectRegistryArray = registries;
                        int n = registries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ObjectRegistry registry;
                            ObjectRegistry objectRegistry = registry = objectRegistryArray[n2];
                            synchronized (objectRegistry) {
                                Integer[] integerArray = registry.instanceIDToObjectReferenceMap.keySet().toArray(new Integer[0]);
                                int n3 = integerArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Integer instanceID = integerArray[n4];
                                    if (((WeakReference)registry.instanceIDToObjectReferenceMap.get(instanceID)).get() == null) {
                                        registry.instanceIDToObjectReferenceMap.remove(instanceID);
                                    }
                                    ++n4;
                                }
                                if (registry.instanceIDToObjectReferenceMap.isEmpty()) {
                                    Set set2 = registrySet;
                                    synchronized (set2) {
                                        registrySet.remove(registry);
                                    }
                                }
                            }
                            ++n2;
                        }
                        set = registrySet;
                        synchronized (set) {
                            if (registrySet.isEmpty()) {
                                cleanUpThread = null;
                                return;
                            }
                        }
                    }
                }
            };
            boolean isApplet = "applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get());
            cleanUpThread.setDaemon(!isApplet);
            cleanUpThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Object o) {
        int instanceID;
        boolean isStartingThread = false;
        ObjectRegistry objectRegistry = this;
        synchronized (objectRegistry) {
            do {
                ++this.nextInstanceID;
            } while (this.instanceIDToObjectReferenceMap.containsKey(instanceID));
            if (o != null) {
                this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o));
                isStartingThread = true;
            }
        }
        if (isStartingThread) {
            ObjectRegistry.startThread(this);
        }
        return instanceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o, int instanceID) {
        ObjectRegistry objectRegistry = this;
        synchronized (objectRegistry) {
            Object o2 = this.get(instanceID);
            if (o2 != null && o2 != o) {
                throw new IllegalStateException("An object is already registered with the id \"" + instanceID + "\" for object: " + o);
            }
            this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o));
        }
        ObjectRegistry.startThread(this);
    }

    public synchronized Object get(int instanceID) {
        WeakReference<Object> weakReference = this.instanceIDToObjectReferenceMap.get(instanceID);
        if (weakReference == null) {
            return null;
        }
        Object o = weakReference.get();
        if (o == null) {
            this.instanceIDToObjectReferenceMap.remove(instanceID);
        }
        return o;
    }

    public synchronized void remove(int instanceID) {
        this.instanceIDToObjectReferenceMap.remove(instanceID);
    }

    public synchronized int[] getInstanceIDs() {
        Object[] instanceIDObjects = this.instanceIDToObjectReferenceMap.keySet().toArray();
        int[] instanceIDs = new int[instanceIDObjects.length];
        int i = 0;
        while (i < instanceIDObjects.length) {
            instanceIDs[i] = (Integer)instanceIDObjects[i];
            ++i;
        }
        return instanceIDs;
    }

    public static ObjectRegistry getInstance() {
        return registry;
    }
}

