/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.services.internal.ProgressManager;
import com.obs.services.internal.io.UnrecoverableIOException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private boolean readFlag;
    private ProgressManager progressManager;
    private boolean endFlag;

    public ProgressInputStream(InputStream in, ProgressManager progressManager) {
        this(in, progressManager, true);
    }

    public ProgressInputStream(InputStream in, ProgressManager progressManager, boolean endFlag) {
        super(in);
        this.progressManager = progressManager;
        this.endFlag = endFlag;
    }

    public final boolean markSupported() {
        return false;
    }

    protected final void abortIfNeeded() {
        if (Thread.interrupted()) {
            throw new RuntimeException("Abort io due to thread interrupted");
        }
    }

    public void mark(int a) {
        this.abortIfNeeded();
    }

    public void reset() throws IOException {
        throw new UnrecoverableIOException("UnRepeatable");
    }

    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        return super.skip(n);
    }

    public int available() throws IOException {
        this.abortIfNeeded();
        return super.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
            this.abortIfNeeded();
            Object var2_1 = null;
            if (this.endFlag) {
                this.progressManager.progressEnd();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.endFlag) {
                this.progressManager.progressEnd();
            }
            throw throwable;
        }
    }

    public int read() throws IOException {
        this.abortIfNeeded();
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.abortIfNeeded();
        if (!this.readFlag) {
            this.readFlag = true;
            this.progressManager.progressStart();
        }
        int bytes = super.read(b, off, len);
        this.progressManager.progressChanged(bytes);
        return bytes;
    }
}

