/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.AbstractVectorModel;
import com.hankcs.hanlp.mining.word2vec.Vector;
import com.hankcs.hanlp.mining.word2vec.WordVectorModel;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.NotionalTokenizer;
import java.util.List;
import java.util.Map;

public class DocVectorModel
extends AbstractVectorModel<Integer> {
    private final WordVectorModel wordVectorModel;

    public DocVectorModel(WordVectorModel wordVectorModel) {
        this.wordVectorModel = wordVectorModel;
    }

    public Vector addDocument(int id, String content) {
        Vector result = this.query(content);
        this.storage.put(id, result);
        return result;
    }

    @Override
    public List<Map.Entry<Integer, Float>> nearest(String query) {
        return this.queryNearest(query, 10);
    }

    @Override
    public Vector query(String content) {
        if (content == null || content.length() == 0) {
            return null;
        }
        List<Term> termList = NotionalTokenizer.segment(content);
        Vector result = new Vector(this.dimension());
        int n = 0;
        for (Term term : termList) {
            Vector vector = this.wordVectorModel.vector(term.word);
            if (vector == null) continue;
            ++n;
            result.addToSelf(vector);
        }
        if (n == 0) {
            return null;
        }
        result.divideToSelf(n);
        return result;
    }

    @Override
    public int dimension() {
        return this.wordVectorModel.dimension();
    }

    @Override
    public float similarity(String what, String with) {
        Vector A = this.query(what);
        if (A == null) {
            return -1.0f;
        }
        Vector B = this.query(with);
        if (B == null) {
            return -1.0f;
        }
        return A.cosine(B);
    }
}

