/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.writer.internal;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.util.Builder;
import com.googlecode.jcsv.writer.CSVColumnJoiner;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import com.googlecode.jcsv.writer.CSVWriter;
import com.googlecode.jcsv.writer.internal.CSVColumnJoinerImpl;
import com.googlecode.jcsv.writer.internal.CSVWriterImpl;
import com.googlecode.jcsv.writer.internal.DefaultCSVEntryConverter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVWriterBuilder<E>
implements Builder<CSVWriter<E>> {
    final Writer writer;
    CSVStrategy strategy = CSVStrategy.DEFAULT;
    CSVEntryConverter<E> entryConverter;
    CSVColumnJoiner columnJoiner = new CSVColumnJoinerImpl();

    public CSVWriterBuilder(Writer writer) {
        this.writer = writer;
    }

    public CSVWriterBuilder<E> strategy(CSVStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CSVWriterBuilder<E> entryConverter(CSVEntryConverter<E> entryConverter) {
        this.entryConverter = entryConverter;
        return this;
    }

    public CSVWriterBuilder<E> columnJoiner(CSVColumnJoiner columnJoiner) {
        this.columnJoiner = columnJoiner;
        return this;
    }

    @Override
    public CSVWriter<E> build() {
        if (this.entryConverter == null) {
            throw new IllegalStateException("you have to specify an entry converter");
        }
        return new CSVWriterImpl(this);
    }

    public static CSVWriter<String[]> newDefaultWriter(Writer writer) {
        return new CSVWriterBuilder<String[]>(writer).entryConverter(new DefaultCSVEntryConverter()).build();
    }
}

