/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.reader.internal;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.reader.CSVEntryFilter;
import com.googlecode.jcsv.reader.CSVEntryParser;
import com.googlecode.jcsv.reader.CSVReader;
import com.googlecode.jcsv.reader.CSVTokenizer;
import com.googlecode.jcsv.reader.internal.CSVReaderBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReaderImpl<E>
implements CSVReader<E> {
    private final BufferedReader reader;
    private final CSVStrategy strategy;
    private final CSVEntryParser<E> entryParser;
    private final CSVEntryFilter<E> entryFilter;
    private final CSVTokenizer tokenizer;
    private boolean firstLineRead = false;

    CSVReaderImpl(CSVReaderBuilder<E> builder) {
        this.reader = new BufferedReader(builder.reader);
        this.strategy = builder.strategy;
        this.entryParser = builder.entryParser;
        this.entryFilter = builder.entryFilter;
        this.tokenizer = builder.tokenizer;
    }

    @Override
    public List<E> readAll() throws IOException {
        ArrayList<Object> entries = new ArrayList<Object>();
        Object entry = null;
        while (true) {
            E e = this.readNext();
            entry = e;
            if (e == null) break;
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public E readNext() throws IOException {
        if (this.strategy.isSkipHeader() && !this.firstLineRead) {
            this.reader.readLine();
        }
        Object entry = null;
        boolean validEntry = false;
        do {
            String line;
            if ((line = this.readLine()) == null) {
                return null;
            }
            if (line.trim().length() == 0 && this.strategy.isIgnoreEmptyLines() || this.isCommentLine(line)) continue;
            List<String> data = this.tokenizer.tokenizeLine(line, this.strategy, this.reader);
            entry = this.entryParser.parseEntry(data.toArray(new String[data.size()]));
            boolean bl = validEntry = this.entryFilter != null ? this.entryFilter.match(entry) : true;
        } while (!validEntry);
        this.firstLineRead = true;
        return entry;
    }

    @Override
    public List<String> readHeader() throws IOException {
        if (this.firstLineRead) {
            throw new IllegalStateException("can not read header, readHeader() must be the first call on this reader");
        }
        String line = this.readLine();
        if (line == null) {
            throw new IllegalStateException("reached EOF while reading the header");
        }
        List<String> header = this.tokenizer.tokenizeLine(line, this.strategy, this.reader);
        return header;
    }

    @Override
    public Iterator<E> iterator() {
        return new CSVIterator();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private boolean isCommentLine(String line) {
        return line.startsWith(String.valueOf(this.strategy.getCommentIndicator()));
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        this.firstLineRead = true;
        return line;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSVIterator
    implements Iterator<E> {
        private E nextEntry;

        private CSVIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            try {
                this.nextEntry = CSVReaderImpl.this.readNext();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return this.nextEntry != null;
        }

        @Override
        public E next() {
            Object entry = null;
            if (this.nextEntry != null) {
                entry = this.nextEntry;
                this.nextEntry = null;
            } else {
                try {
                    entry = CSVReaderImpl.this.readNext();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("this iterator doesn't support object deletion");
        }
    }
}

