/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jcsv.reader.internal;

import com.googlecode.jcsv.annotations.MapToColumn;
import com.googlecode.jcsv.annotations.ValueProcessor;
import com.googlecode.jcsv.annotations.internal.ValueProcessorProvider;
import com.googlecode.jcsv.reader.CSVEntryParser;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEntryParser<E>
implements CSVEntryParser<E> {
    private final Class<E> clazz;
    private final ValueProcessorProvider provider;

    public AnnotationEntryParser(Class<E> clazz, ValueProcessorProvider provider) {
        this.clazz = clazz;
        this.provider = provider;
    }

    @Override
    public E parseEntry(String ... data) {
        E entry = this.newClassIntance();
        this.fillObject(entry, data);
        return entry;
    }

    private E newClassIntance() {
        E entry;
        try {
            entry = this.clazz.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(String.format("can not instantiate class %s", this.clazz.getName()), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(String.format("can not access class %s", this.clazz.getName()), iae);
        }
        return entry;
    }

    private void fillObject(E entry, String[] data) {
        for (Field field : entry.getClass().getDeclaredFields()) {
            MapToColumn mapAnnotation = field.getAnnotation(MapToColumn.class);
            if (mapAnnotation == null) continue;
            int column = mapAnnotation.column();
            Class<?> type = mapAnnotation.type().equals(MapToColumn.Default.class) ? field.getType() : mapAnnotation.type();
            ValueProcessor<?> vp = this.provider.getValueProcessor(type);
            Object value = vp.processValue(data[column]);
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(entry, value);
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException(String.format("can not set value %s for type %s", value, type), iae);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(String.format("can not access field %s", field), iae);
            }
            field.setAccessible(wasAccessible);
        }
    }
}

