/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Ordered;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

public class MapSubject
extends Subject<MapSubject, Map<?, ?>> {
    MapSubject(FailureStrategy failureStrategy, @Nullable Map<?, ?> map) {
        super(failureStrategy, map);
    }

    @Override
    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.actual(), (Object)other)) {
            if (other instanceof Map) {
                MapDifference diff = Maps.difference((Map)((Map)other), (Map)((Map)this.actual()));
                String errorMsg = "The subject";
                if (!diff.entriesOnlyOnLeft().isEmpty()) {
                    errorMsg = errorMsg + " is missing the following entries: " + diff.entriesOnlyOnLeft();
                    if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                        errorMsg = errorMsg + " and";
                    }
                }
                if (!diff.entriesOnlyOnRight().isEmpty()) {
                    errorMsg = errorMsg + " has the following extra entries: " + diff.entriesOnlyOnRight();
                    if (!diff.entriesDiffering().isEmpty()) {
                        errorMsg = errorMsg + " and";
                    }
                }
                if (!diff.entriesDiffering().isEmpty()) {
                    errorMsg = errorMsg + " has the following different entries: " + diff.entriesDiffering();
                }
                this.failWithRawMessage("Not true that %s is equal to <%s>. " + errorMsg, this.actualAsString(), other);
            } else {
                this.fail("is equal to", other);
            }
        }
    }

    public void isEmpty() {
        if (!((Map)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Map)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (int)expectedSize);
        int actualSize = ((Map)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void containsKey(@Nullable Object key) {
        if (!((Map)this.actual()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(@Nullable Object key) {
        if (((Map)this.actual()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!((Map)this.actual()).entrySet().contains(entry)) {
            if (((Map)this.actual()).containsKey(key)) {
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, it has a mapping from <%s> to <%s>", this.actualAsString(), entry, key, ((Map)this.actual()).get(key));
            }
            if (((Map)this.actual()).containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : ((Map)this.actual()).entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.actualAsString(), entry, value, keys);
            }
            this.fail("contains entry", (Object)entry);
        }
    }

    public void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (((Map)this.actual()).entrySet().contains(entry)) {
            this.fail("does not contain entry", (Object)entry);
        }
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.check().that(((Map)this.actual()).entrySet()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MapSubject.accumulateMap(k0, v0, rest));
    }

    private static Map<Object, Object> accumulateMap(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        LinkedHashMap expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset keys = LinkedHashMultiset.create();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys.add(key);
        }
        Preconditions.checkArgument((keys.size() == expectedMap.size() ? 1 : 0) != 0, (String)"Duplicate keys (%s) cannot be passed to containsExactly().", (Object)keys);
        return expectedMap;
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        return this.check().that(((Map)this.actual()).entrySet()).containsExactlyElementsIn(expectedMap.entrySet());
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<A, E> correspondence;

        private UsingCorrespondence(Correspondence<A, E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, @Nullable E expectedValue) {
            if (((Map)MapSubject.this.actual()).containsKey(expectedKey)) {
                A actualValue = this.getCastSubject().get(expectedKey);
                if (this.correspondence.compare(actualValue, expectedValue)) {
                    return;
                }
                MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, actualValue);
            } else {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry<?, A> actualEntry : this.getCastSubject().entrySet()) {
                    if (!this.correspondence.compare(actualEntry.getValue(), expectedValue)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, keys);
                } else {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue);
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, @Nullable E excludedValue) {
            A actualValue;
            if (((Map)MapSubject.this.actual()).containsKey(excludedKey) && this.correspondence.compare(actualValue = this.getCastSubject().get(excludedKey), excludedValue)) {
                MapSubject.this.failWithRawMessage("Not true that %s does not contain an entry with key <%s> and a value that %s <%s>. It maps that key to <%s>", MapSubject.this.actualAsString(), excludedKey, this.correspondence, excludedValue, actualValue);
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public <K, V extends E> Ordered containsExactlyEntriesIn(Map<K, V> expectedMap) {
            return MapSubject.this.check().that(((Map)MapSubject.this.actual()).entrySet()).comparingElementsUsing(new EntryCorrespondence()).containsExactlyElementsIn(expectedMap.entrySet());
        }

        private Map<?, A> getCastSubject() {
            return (Map)MapSubject.this.actual();
        }

        private final class EntryCorrespondence<K, V extends E>
        extends Correspondence<Map.Entry<Object, A>, Map.Entry<K, V>> {
            private EntryCorrespondence() {
            }

            @Override
            public boolean compare(Map.Entry<Object, A> actual, Map.Entry<K, V> expected) {
                return actual.getKey().equals(expected.getKey()) && UsingCorrespondence.this.correspondence.compare(actual.getValue(), expected.getValue());
            }

            @Override
            public String toString() {
                return StringUtil.format("has a key that is equal to and a value that %s the key and value of", UsingCorrespondence.this.correspondence);
            }
        }
    }
}

