/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public final class ThrowableSubject
extends Subject<ThrowableSubject, Throwable> {
    public ThrowableSubject(FailureStrategy failureStrategy, @Nullable Throwable throwable) {
        super(ThrowableSubject.causeInsertingStrategy(failureStrategy, throwable), throwable);
    }

    public void hasMessage(@Nullable String expected) {
        String actual = ((Throwable)this.getSubject()).getMessage();
        if (!Objects.equal((Object)expected, (Object)actual)) {
            if (expected != null && actual != null) {
                this.failureStrategy.failComparing(this.getDisplaySubject() + " does not have message <" + expected + ">", expected, actual);
            } else {
                this.fail("has message", (Object)expected);
            }
        }
    }

    private static FailureStrategy causeInsertingStrategy(final FailureStrategy delegate, final Throwable defaultCause) {
        return new FailureStrategy(){

            @Override
            public void fail(String message) {
                delegate.fail(message, defaultCause);
            }

            @Override
            public void fail(String message, Throwable cause) {
                delegate.fail(message, cause);
            }

            @Override
            public void failComparing(String message, CharSequence expected, CharSequence actual) {
                try {
                    delegate.failComparing(message, expected, actual);
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).initCause(defaultCause);
                    throw e;
                }
            }
        };
    }
}

