/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class StringSubject
extends ComparableSubject<StringSubject, String> {
    public StringSubject(FailureStrategy failureStrategy, @Nullable String string) {
        super(failureStrategy, string);
    }

    @Override
    protected String getDisplaySubject() {
        if (this.internalCustomName() != null) {
            return this.internalCustomName() + " (<" + StringSubject.quote((CharSequence)this.getSubject()) + ">)";
        }
        return "<" + StringSubject.quote((CharSequence)this.getSubject()) + ">";
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        if (this.getSubject() == null) {
            if (expected != null) {
                if (expected instanceof String) {
                    this.failWithRawMessage("Not true that " + this.getDisplaySubject() + " is equal to <%s>", StringSubject.quote((String)expected));
                } else {
                    this.failWithRawMessage("Not true that " + this.getDisplaySubject() + " is equal to (%s)<%s>", expected.getClass().getName(), expected);
                }
            }
        } else if (expected == null) {
            this.isNull();
        } else if (!(expected instanceof String)) {
            this.failWithRawMessage("Not true that %s is equal to (%s)<%s>", this.getDisplaySubject(), expected.getClass().getName(), expected);
        } else if (!((String)this.getSubject()).equals(expected)) {
            if (this.internalCustomName() != null) {
                this.failureStrategy.failComparing("\"" + this.internalCustomName() + "\":", (String)expected, (CharSequence)this.getSubject());
            } else {
                this.failureStrategy.failComparing("", (String)expected, (CharSequence)this.getSubject());
            }
        }
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(String other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    @Override
    public void isNull() {
        if (this.getSubject() != null) {
            this.failWithRawMessage("Not true that %s is null", this.getDisplaySubject());
        }
    }

    public void hasLength(int expectedLength) {
        Preconditions.checkArgument((expectedLength >= 0 ? 1 : 0) != 0, (String)"expectedLength(%s) must be >= 0", (Object[])new Object[]{expectedLength});
        int actualLength = ((String)this.getSubject()).length();
        if (actualLength != expectedLength) {
            this.failWithRawMessage("Not true that %s has a length of %s. It is %s.", this.getDisplaySubject(), expectedLength, actualLength);
        }
    }

    public void isEmpty() {
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference is empty", new Object[0]);
        } else if (!((String)this.getSubject()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference is not empty", new Object[0]);
        } else if (((String)this.getSubject()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void contains(CharSequence string) {
        Preconditions.checkNotNull((Object)string);
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).contains(string)) {
            this.fail("contains", (Object)StringSubject.quote(string));
        }
    }

    public void doesNotContain(CharSequence string) {
        Preconditions.checkNotNull((Object)string);
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (((String)this.getSubject()).contains(string)) {
            this.failWithRawMessage("%s unexpectedly contains <%s>", this.getDisplaySubject(), StringSubject.quote(string));
        }
    }

    public void startsWith(String string) {
        Preconditions.checkNotNull((Object)string);
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference starts with <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).startsWith(string)) {
            this.fail("starts with", (Object)StringSubject.quote(string));
        }
    }

    public void endsWith(String string) {
        Preconditions.checkNotNull((Object)string);
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference ends with <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).endsWith(string)) {
            this.fail("ends with", (Object)StringSubject.quote(string));
        }
    }

    public void matches(String regex) {
        if (!((String)this.getSubject()).matches(regex)) {
            this.fail("matches", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void matches(Pattern regex) {
        if (!regex.matcher((CharSequence)this.getSubject()).matches()) {
            this.fail("matches", (Object)regex);
        }
    }

    public void doesNotMatch(String regex) {
        if (((String)this.getSubject()).matches(regex)) {
            this.fail("fails to match", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotMatch(Pattern regex) {
        if (regex.matcher((CharSequence)this.getSubject()).matches()) {
            this.fail("fails to match", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void containsMatch(Pattern pattern) {
        if (!pattern.matcher((CharSequence)this.getSubject()).find()) {
            this.failWithRawMessage("%s should have contained a match for <%s>", this.getDisplaySubject(), pattern);
        }
    }

    public void containsMatch(String regex) {
        if (!Platform.containsMatch((String)this.getSubject(), regex)) {
            this.failWithRawMessage("%s should have contained a match for <%s>", this.getDisplaySubject(), regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotContainMatch(Pattern pattern) {
        if (pattern.matcher((CharSequence)this.getSubject()).find()) {
            this.failWithRawMessage("%s should not have contained a match for <%s>", this.getDisplaySubject(), pattern);
        }
    }

    public void doesNotContainMatch(String regex) {
        if (Platform.containsMatch((String)this.getSubject(), regex)) {
            this.failWithRawMessage("%s should not have contained a match for <%s>", this.getDisplaySubject(), regex);
        }
    }

    private static String quote(@Nullable CharSequence toBeWrapped) {
        return toBeWrapped == null ? "null" : "\"" + toBeWrapped + "\"";
    }
}

